/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft;

import com.lance5057.butchercraft.ButchercraftConfig;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftMobEffects;
import com.lance5057.butchercraft.capabilities.AnimalCare;
import com.lance5057.butchercraft.capabilities.AnimalCareProvider;
import com.lance5057.butchercraft.entity.ai.AngryAnimalAttackGoal;
import com.lance5057.butchercraft.entity.ai.AngryAnimalTargetGoal;
import com.lance5057.butchercraft.entity.ai.ClothingTemptGoal;
import com.lance5057.butchercraft.items.WolfFoodSpecialItem;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="butchercraft", bus=EventBusSubscriber.Bus.GAME)
public class ButchercraftForgeEvents {
    @SubscribeEvent
    public static void giveHoodsToUndead(FinalizeSpawnEvent event) {
        Mob e;
        ServerLevel level;
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel && (level = (ServerLevel)serverLevelAccessor).getRandom().nextFloat() <= ((Double)ButchercraftConfig.HOOD_SPAWN_CHANCE.get()).floatValue() && ((e = event.getEntity()) instanceof Zombie || e instanceof Skeleton)) {
            int choice = event.getLevel().getRandom().nextInt(6);
            block0 : switch (choice) {
                case 0: {
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.COW_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.COW);
                    break;
                }
                case 1: {
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.GOAT_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.GOAT);
                    break;
                }
                case 2: {
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.PIG_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.PIG);
                    break;
                }
                case 3: {
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SHEEP_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.SHEEP);
                    break;
                }
                case 4: {
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.CHICKEN_MASK.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.CHICKEN);
                    break;
                }
                default: {
                    int rabbit = event.getLevel().getRandom().nextInt(6);
                    switch (rabbit) {
                        case 0: {
                            e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.BLACK_BUNNY_EARS.get()));
                            e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.BLACK_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.BLACK);
                            break block0;
                        }
                        case 1: {
                            e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.BROWN_BUNNY_EARS.get()));
                            e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.BROWN_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.BROWN);
                            break block0;
                        }
                        case 2: {
                            e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.GOLD_BUNNY_EARS.get()));
                            e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.GOLD_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.GOLD);
                            break block0;
                        }
                        case 3: {
                            e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SALT_BUNNY_EARS.get()));
                            e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.SALT_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.SALT);
                            break block0;
                        }
                        case 4: {
                            e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_EARS.get()));
                            e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.WHITE_SPLOTCHED);
                            break block0;
                        }
                    }
                    e.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.WHITE_BUNNY_EARS.get()));
                    e.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.WHITE_BUNNY_TAIL.get()));
                    ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.RABBIT, Rabbit.Variant.WHITE);
                }
            }
        }
    }

    private static void spawnArmy(ServerLevel level, Mob e, EntityType<?> type) {
        if (level.dimension() == Level.OVERWORLD && level.canSeeSky(e.blockPosition()) && level.getRandom().nextFloat() <= ((Double)ButchercraftConfig.HOOD_ARMY_CHANCE.get()).floatValue()) {
            int animalsAmount = level.getRandom().nextInt(4) + 2;
            for (int i = 0; i < animalsAmount; ++i) {
                Animal ent = (Animal)type.spawn(level, e.blockPosition().offset(level.getRandom().nextInt(6) - 3, 0, level.getRandom().nextInt(6) - 3), MobSpawnType.EVENT);
                ent.addEffect(new MobEffectInstance(ButchercraftMobEffects.BLOODLUST, 3600));
            }
        }
    }

    private static void spawnRabbitArmy(ServerLevel level, Mob e, EntityType<?> type, Rabbit.Variant skin) {
        if (level.dimension() == Level.OVERWORLD && level.canSeeSky(e.blockPosition()) && level.getRandom().nextFloat() <= ((Double)ButchercraftConfig.HOOD_ARMY_CHANCE.get()).floatValue()) {
            int animalsAmount = level.getRandom().nextInt(4) + 2;
            for (int i = 0; i < animalsAmount; ++i) {
                Rabbit ent = (Rabbit)type.spawn(level, e.blockPosition().offset(level.getRandom().nextInt(6) - 3, 0, level.getRandom().nextInt(6) - 3), MobSpawnType.EVENT);
                ent.setVariant(skin);
                ent.addEffect(new MobEffectInstance(ButchercraftMobEffects.BLOODLUST, 3600));
            }
        }
    }

    @SubscribeEvent
    public static void bloodyTrail(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob instanceof Zombie) {
            Zombie z = (Zombie)mob;
            for (Player p : event.getLevel().players()) {
                if (!p.hasEffect(ButchercraftMobEffects.BLOODTRAIL)) continue;
                z.setTarget((LivingEntity)p);
            }
        }
    }

    @SubscribeEvent
    public static void breedEvent(BabyEntitySpawnEvent event) {
        Level level = event.getChild().level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (event.getChild() instanceof Cow) {
                Cow baby = (Cow)event.getChild();
                Cow pA = (Cow)event.getParentA();
                Cow pB = (Cow)event.getParentB();
                baby.setAge((int)(-24000.0 * (Double)ButchercraftConfig.AGE_MULTIPLIER.get()));
                pA.setAge((int)(6000.0 * (Double)ButchercraftConfig.BREEDING_MULTIPLIER.get()));
                pB.setAge((int)(6000.0 * (Double)ButchercraftConfig.BREEDING_MULTIPLIER.get()));
                float pAN = Optional.ofNullable((AnimalCare)pA.getCapability(AnimalCareProvider.CARE)).map(i -> Float.valueOf(i.getNutrition())).orElse(Float.valueOf(((Double)ButchercraftConfig.WILDLIFE_NUTRITION.get()).floatValue())).floatValue();
                float pBN = Optional.ofNullable((AnimalCare)pB.getCapability(AnimalCareProvider.CARE)).map(i -> Float.valueOf(i.getNutrition())).orElse(Float.valueOf(((Double)ButchercraftConfig.WILDLIFE_NUTRITION.get()).floatValue())).floatValue();
                if (pAN + pBN >= 2.0f) {
                    Optional.ofNullable((AnimalCare)baby.getCapability(AnimalCareProvider.CARE)).ifPresent(i -> i.setNutrition(0.9f));
                    Cow baby2 = (Cow)baby.getType().spawn(server, null, event.getCausedByPlayer(), pA.blockPosition(), MobSpawnType.BREEDING, true, false);
                    baby2.setBaby(true);
                    Optional.ofNullable((AnimalCare)baby2.getCapability(AnimalCareProvider.CARE)).ifPresent(i -> i.setNutrition(0.9f));
                } else {
                    float bred = Math.max(pAN, pBN) + Math.min(pAN, pBN) / 2.0f;
                    Optional.ofNullable((AnimalCare)baby.getCapability(AnimalCareProvider.CARE)).ifPresent(i -> i.setNutrition(bred));
                }
            }
        }
    }

    @SubscribeEvent
    public static void cancelInteractions(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager v = (Villager)entity;
            if (event.getEntity().hasEffect(ButchercraftMobEffects.STINKY) || event.getEntity().hasEffect(ButchercraftMobEffects.BLOODY)) {
                v.setUnhappyCounter(40);
                if (!v.level().isClientSide()) {
                    v.playSound(SoundEvents.VILLAGER_NO, 1.0f, v.getVoicePitch());
                }
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void cancelEat(LivingEntityUseItemEvent.Start event) {
        ItemStack stack;
        if (event.getEntity().hasEffect(ButchercraftMobEffects.STINKY) && ((stack = event.getItem()).getFoodProperties(event.getEntity()) != null || stack.getItem() instanceof PotionItem || stack.getItem() instanceof MilkBucketItem)) {
            event.getEntity().addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void dirtyHands(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        if (event.getEntity().hasEffect(ButchercraftMobEffects.DIRTY) && ((stack = event.getItem()).getFoodProperties(event.getEntity()) != null || stack.getItem() instanceof PotionItem || stack.getItem() instanceof MilkBucketItem)) {
            switch (event.getEntity().level().random.nextInt(3)) {
                case 0: {
                    event.getEntity().addEffect(new MobEffectInstance(MobEffects.POISON, 600));
                }
                case 1: {
                    event.getEntity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 600));
                }
            }
            event.getEntity().addEffect(new MobEffectInstance(MobEffects.HUNGER, 600));
        }
    }

    @SubscribeEvent
    public static void buffZombie(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof Zombie) {
            Zombie z = (Zombie)entity;
            if (event.getEntity().hasEffect(ButchercraftMobEffects.BLOODY)) {
                z.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 0));
                z.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 0));
            }
        }
    }

    @SubscribeEvent
    public static void EntityJoined(EntityJoinLevelEvent event) {
        Pig p;
        Entity e = event.getEntity();
        if (e instanceof Pig) {
            p = (Pig)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.PIG_HOOD.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.goalSelector.addGoal(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Cow) {
            p = (Cow)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.COW_HOOD.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.goalSelector.addGoal(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Sheep) {
            p = (Sheep)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.SHEEP_HOOD.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.goalSelector.addGoal(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Goat) {
            p = (Goat)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.GOAT_HOOD.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.goalSelector.addGoal(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Chicken) {
            p = (Chicken)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.CHICKEN_MASK.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.goalSelector.addGoal(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Rabbit) {
            p = (Rabbit)e;
            p.goalSelector.addGoal(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.BLACK_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.BROWN_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.GOLD_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.SALT_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.WHITE_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.BLACK_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.BROWN_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.GOLD_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.SALT_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.WHITE_BUNNY_TAIL.get()}), false));
            p.targetSelector.addGoal(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
        }
    }

    @SubscribeEvent
    public static void wolfInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof WolfFoodSpecialItem) {
            WolfFoodSpecialItem item2 = (WolfFoodSpecialItem)item;
            item = event.getTarget();
            if (item instanceof Wolf) {
                Wolf w = (Wolf)item;
                w.addEffect(new MobEffectInstance(item2.getEffect(), 1200, 1));
                event.getItemStack().shrink(1);
                w.isShaking = true;
            }
        }
    }
}

