/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.networking.payload;

import cc.abbie.emi_ores.EmiOres;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;

public record S2CSendFeaturesPayload(Map<ResourceLocation, PlacedFeature> features) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CSendFeaturesPayload> TYPE = new CustomPacketPayload.Type(EmiOres.id("send_features"));
    public static final StreamCodec<FriendlyByteBuf, S2CSendFeaturesPayload> CODEC = StreamCodec.of(S2CSendFeaturesPayload::encode, S2CSendFeaturesPayload::decode);
    private static final Gson GSON = new Gson();
    private static final StreamCodec<ByteBuf, PlacedFeature> PLACED_FEATURE_CODEC = ByteBufCodecs.STRING_UTF8.map(json -> {
        JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (String)json, JsonElement.class);
        DataResult dataresult = PlacedFeature.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return (PlacedFeature)dataresult.getOrThrow(string -> new DecoderException("Failed to decode json: " + string));
    }, feature -> GSON.toJson((JsonElement)PlacedFeature.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, feature).getOrThrow(string -> new EncoderException("Failed to encode json: " + string))));

    public static S2CSendFeaturesPayload decode(FriendlyByteBuf buffer) {
        Map features = buffer.readMap((StreamDecoder)ResourceLocation.STREAM_CODEC, PLACED_FEATURE_CODEC);
        return new S2CSendFeaturesPayload(features);
    }

    public static void encode(FriendlyByteBuf buffer, S2CSendFeaturesPayload packet) {
        buffer.writeMap(packet.features, (StreamEncoder)ResourceLocation.STREAM_CODEC, PLACED_FEATURE_CODEC);
    }

    @NotNull
    public CustomPacketPayload.Type<S2CSendFeaturesPayload> type() {
        return TYPE;
    }
}

