/*
 * Decompiled with CFR 0.152.
 */
package jdlenl.thaumon.block.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalStandBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CrystalStandBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.thaumon.canbeplaced"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        VoxelShape shape = switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), (VoxelShape[])new VoxelShape[]{CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), CrystalStandBlock.box((double)7.0, (double)2.5, (double)7.0, (double)9.0, (double)3.0, (double)9.0), CrystalStandBlock.box((double)7.5, (double)0.5, (double)7.5, (double)8.5, (double)2.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)3.0, (double)7.5, (double)8.5, (double)5.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)6.0, (double)8.0, (double)8.0, (double)6.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)5.5, (double)7.5, (double)8.0, (double)6.0, (double)8.5), CrystalStandBlock.box((double)8.0, (double)5.5, (double)8.0, (double)8.5, (double)6.0, (double)8.5)});
            case Direction.EAST -> Shapes.or((VoxelShape)CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), (VoxelShape[])new VoxelShape[]{CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), CrystalStandBlock.box((double)7.0, (double)2.5, (double)7.0, (double)9.0, (double)3.0, (double)9.0), CrystalStandBlock.box((double)7.5, (double)0.5, (double)7.5, (double)8.5, (double)2.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)3.0, (double)7.5, (double)8.5, (double)5.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)6.0, (double)7.5, (double)8.0, (double)6.5, (double)8.0), CrystalStandBlock.box((double)7.5, (double)5.5, (double)7.5, (double)8.5, (double)6.0, (double)8.0), CrystalStandBlock.box((double)7.5, (double)5.5, (double)8.0, (double)8.0, (double)6.0, (double)8.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), (VoxelShape[])new VoxelShape[]{CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), CrystalStandBlock.box((double)7.0, (double)2.5, (double)7.0, (double)9.0, (double)3.0, (double)9.0), CrystalStandBlock.box((double)7.5, (double)0.5, (double)7.5, (double)8.5, (double)2.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)3.0, (double)7.5, (double)8.5, (double)5.5, (double)8.5), CrystalStandBlock.box((double)8.0, (double)6.0, (double)8.0, (double)8.5, (double)6.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)5.5, (double)8.0, (double)8.5, (double)6.0, (double)8.5), CrystalStandBlock.box((double)8.0, (double)5.5, (double)7.5, (double)8.5, (double)6.0, (double)8.0)});
            default -> Shapes.or((VoxelShape)CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), (VoxelShape[])new VoxelShape[]{CrystalStandBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)0.5, (double)9.0), CrystalStandBlock.box((double)7.0, (double)2.5, (double)7.0, (double)9.0, (double)3.0, (double)9.0), CrystalStandBlock.box((double)7.5, (double)0.5, (double)7.5, (double)8.5, (double)2.5, (double)8.5), CrystalStandBlock.box((double)7.5, (double)3.0, (double)7.5, (double)8.5, (double)5.5, (double)8.5), CrystalStandBlock.box((double)8.0, (double)6.0, (double)7.5, (double)8.5, (double)6.5, (double)8.0), CrystalStandBlock.box((double)8.0, (double)5.5, (double)7.5, (double)8.5, (double)6.0, (double)8.5), CrystalStandBlock.box((double)7.5, (double)5.5, (double)7.5, (double)8.0, (double)6.0, (double)8.0)});
        };
        return shape.move(offset.x, offset.y, offset.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public SoundType getSoundType(BlockState state) {
        return new SoundType(1.0f, 1.0f, SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.lantern.break")), SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.amethyst_cluster.step")), SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.amethyst_cluster.place")), SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.lantern.hit")), SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.amethyst_cluster.fall")));
    }
}

