/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.data;

import appeng.core.definitions.BlockDefinition;
import es.degrassi.appexp.block.ExperienceConverterBlock;
import es.degrassi.appexp.definition.AExpBlocks;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootProvider
extends BlockLootSubProvider {
    public LootProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.DEFAULT_FLAGS, registries);
    }

    protected void generate() {
        for (Block block : this.getKnownBlocks()) {
            if (block instanceof ExperienceConverterBlock) {
                ExperienceConverterBlock exp = (ExperienceConverterBlock)block;
                this.add(exp, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).when(ExplosionCondition.survivesExplosion()).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY))));
                continue;
            }
            this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).when(ExplosionCondition.survivesExplosion())));
        }
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.blocks().stream().map(BlockDefinition::block).map(Block.class::cast)::iterator;
    }

    private List<BlockDefinition<?>> blocks() {
        return AExpBlocks.getBlocks();
    }
}

