/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integratedtunnels.core.TunnelItemHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class IngredientPredicateBlockList
extends IngredientPredicate<ItemStack, Integer> {
    private final boolean blacklist;
    private final IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock> blocks;
    private final boolean checkStackSize;
    private final boolean checkItem;
    private final boolean checkNbt;

    public IngredientPredicateBlockList(boolean blacklist, int amount, boolean exactAmount, IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock> blocks, int matchFlags, boolean checkStackSize, boolean checkItem, boolean checkNbt) {
        super(IngredientComponent.ITEMSTACK, Iterables.transform((Iterable)Iterables.filter(blocks, block -> block.getRawValue().isPresent()), block -> TunnelItemHelpers.prototypeWithCount(BlockHelpers.getItemStackFromBlockState((BlockState)((BlockState)block.getRawValue().get())), amount)), Integer.valueOf(matchFlags), blacklist, false, amount, exactAmount);
        this.blacklist = blacklist;
        this.blocks = blocks;
        this.checkStackSize = checkStackSize;
        this.checkItem = checkItem;
        this.checkNbt = checkNbt;
    }

    @Override
    public boolean test(@Nullable ItemStack input) {
        for (ValueObjectTypeBlock.ValueBlock block : this.blocks) {
            if (!block.getRawValue().isPresent() || !TunnelItemHelpers.areItemStackEqual(input, BlockHelpers.getItemStackFromBlockState((BlockState)((BlockState)block.getRawValue().get())), this.checkStackSize, this.checkItem, this.checkNbt)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicateBlockList)) {
            return false;
        }
        IngredientPredicateBlockList that = (IngredientPredicateBlockList)obj;
        return super.equals(obj) && this.blacklist == that.blacklist && this.checkItem == that.checkItem && this.checkStackSize == that.checkStackSize && this.checkNbt == that.checkNbt && this.blocks.equals(that.blocks);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.blacklist ? 1 : 0) << 1 ^ (this.checkItem ? 1 : 0) << 2 ^ (this.checkStackSize ? 1 : 0) << 3 ^ (this.checkNbt ? 1 : 0) << 4 ^ this.blocks.hashCode();
    }
}

