/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.monster.Wraith;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureProcessors;
import twilightforest.loot.TFLootTables;
import twilightforest.util.features.FeatureLogic;

public class GraveyardFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation GRAVEYARD = TwilightForestMod.prefix("feature/graveyard/graveyard");
    private static final ResourceLocation TRAP = TwilightForestMod.prefix("feature/graveyard/grave_trap");

    public GraveyardFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    private static boolean offsetToAverageGroundLevel(WorldGenLevel world, BlockPos.MutableBlockPos startPos, Vec3i size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.getX(); ++dx) {
            for (int dz = 0; dz < size.getZ(); ++dz) {
                int y;
                int x = startPos.getX() + dx;
                int z = startPos.getZ() + dz;
                for (y = world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z); y >= 0; --y) {
                    BlockState state = world.getBlockState(new BlockPos(x, y, z));
                    if (FeatureLogic.isBlockNotOk(state)) {
                        return false;
                    }
                    if (FeatureLogic.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.setY(baseY);
        return FeatureLogic.isAreaClear((BlockGetter)world, startPos.above(maxY - baseY + 1), startPos.offset(size));
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel world = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        int flags = 19;
        StructureTemplateManager templatemanager = world.getLevel().getServer().getStructureManager();
        StructureTemplate base = templatemanager.getOrCreate(GRAVEYARD);
        if (base == null) {
            return false;
        }
        ArrayList<Pair> graves = new ArrayList<Pair>();
        StructureTemplate trap = templatemanager.getOrCreate(TRAP);
        if (trap == null) {
            return false;
        }
        for (GraveType type : GraveType.VALUES) {
            StructureTemplate grave = templatemanager.getOrCreate(type.RL);
            if (grave == null) {
                return false;
            }
            graves.add(Pair.of((Object)((Object)type), (Object)grave));
        }
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[rand.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[rand.nextInt(mirrors.length + 1) % mirrors.length];
        Vec3i transformedSize = base.getSize(rotation);
        Vec3i transformedGraveSize = ((StructureTemplate)((Pair)graves.get(0)).getValue()).getSize(rotation);
        ChunkPos chunkpos = new ChunkPos(pos.offset(-8, 0, -8));
        ChunkPos chunkendpos = new ChunkPos(pos.offset(-8, 0, -8).offset(transformedSize));
        BoundingBox structureboundingbox = new BoundingBox(chunkpos.getMinBlockX() + 8, 0, chunkpos.getMinBlockZ() + 8, chunkendpos.getMaxBlockX() + 8, 255, chunkendpos.getMaxBlockZ() + 8);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(mirror).setRotation(rotation).setBoundingBox(structureboundingbox).setRandom(rand);
        BlockPos posSnap = chunkpos.getWorldPosition().offset(8, pos.getY() - 1, 8);
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos(posSnap.getX(), posSnap.getY(), posSnap.getZ());
        if (!GraveyardFeature.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = base.getZeroPositionWithTransform((BlockPos)startPos, mirror, rotation).offset(1, -1, 0);
        Vec3i size = transformedSize.offset(-1, 0, -1);
        Vec3i graveSize = transformedGraveSize.offset(-1, 0, -1);
        base.placeInWorld((ServerLevelAccessor)world, placementPos, placementPos, placementsettings.addProcessor((StructureProcessor)new WebTemplateProcessor()), rand, flags);
        ArrayList data = new ArrayList(base.filterBlocks(placementPos, placementsettings, Blocks.STRUCTURE_BLOCK));
        BlockPos start = startPos.offset(1, 1, 0);
        BlockPos end = start.offset(size.getX(), 0, size.getZ());
        for (int x = 1; x <= size.getX() - 1; ++x) {
            for (int z = 1; z <= size.getZ() - 1; ++z) {
                if (!world.isEmptyBlock(start.offset(x, 0, z)) || rand.nextInt(12) != 0) continue;
                world.setBlock(start.offset(x, 0, z), Blocks.COBWEB.defaultBlockState(), flags);
            }
        }
        BlockPos inner = start.offset(2, 0, 2);
        BlockPos bound = end.offset(-2, 0, -2);
        BlockPos innerSize = new BlockPos(bound.getX() - inner.getX(), bound.getY() - inner.getY(), bound.getZ() - inner.getZ());
        BlockPos fixed = inner.offset((rotation == Rotation.CLOCKWISE_180 ? graveSize.getX() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.getX() - 1 : 0) * (rotation == Rotation.CLOCKWISE_180 ? -1 : 1), 0, (rotation == Rotation.COUNTERCLOCKWISE_90 ? graveSize.getZ() : 0) + (mirror == Mirror.FRONT_BACK ? transformedGraveSize.getZ() - 1 : 0) * (rotation == Rotation.COUNTERCLOCKWISE_90 ? -1 : 1));
        BlockPos fixedSize = innerSize.offset(-graveSize.getX(), 0, -graveSize.getZ());
        BlockPos chestloc = new BlockPos(rand.nextInt(2) - (mirror == Mirror.FRONT_BACK ? 1 : 0), 1, 0).rotate(rotation);
        for (int x = 0; x <= fixedSize.getX(); x += rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90 ? 2 : 5) {
            for (int z = 0; z <= fixedSize.getZ(); z += rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180 ? 2 : 5) {
                if (x == innerSize.getX() / 2 || z == innerSize.getZ() / 2) continue;
                BlockPos placement = fixed.offset(x, -2, z);
                Pair grave = (Pair)graves.get(rand.nextInt(graves.size()));
                ((StructureTemplate)grave.getValue()).placeInWorld((ServerLevelAccessor)world, placement, placement, placementsettings, rand, flags);
                data.addAll(((StructureTemplate)grave.getValue()).filterBlocks(placement, placementsettings, Blocks.STRUCTURE_BLOCK));
                if (grave.getKey() != GraveType.Full || !rand.nextBoolean()) continue;
                if (rand.nextInt(3) == 0) {
                    placement = placement.offset((Vec3i)new BlockPos(mirror == Mirror.FRONT_BACK ? 1 : -1, 0, mirror == Mirror.LEFT_RIGHT ? 1 : -1).rotate(rotation));
                    trap.placeInWorld((ServerLevelAccessor)world, placement, placement, placementsettings, rand, flags);
                }
                data.addAll(trap.filterBlocks(placementPos, placementsettings, Blocks.STRUCTURE_BLOCK));
                if (world.setBlock(placement.offset((Vec3i)chestloc), ((BlockState)Blocks.TRAPPED_CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.WEST)).rotate(rotation).mirror(mirror), flags)) {
                    TFLootTables.generateChestContents(world, placement.offset((Vec3i)chestloc), TFLootTables.GRAVEYARD);
                    world.setBlock(placement.offset((Vec3i)chestloc).below(), Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3);
                }
                Wraith wraith = new Wraith((EntityType<? extends Wraith>)((EntityType)TFEntities.WRAITH.get()), (Level)world.getLevel());
                wraith.setPos(placement.getX(), placement.getY(), placement.getZ());
                EventHooks.finalizeMobSpawn((Mob)wraith, (ServerLevelAccessor)world, (DifficultyInstance)world.getCurrentDifficultyAt(placement), (MobSpawnType)MobSpawnType.STRUCTURE, null);
                world.addFreshEntity((Entity)wraith);
            }
        }
        data.forEach(info -> {
            if (info.nbt() != null && StructureMode.valueOf((String)info.nbt().getString("mode")) == StructureMode.DATA) {
                String s = info.nbt().getString("metadata");
                BlockPos p = info.pos();
                if ("spawner".equals(s)) {
                    SpawnerBlockEntity ms;
                    world.removeBlock(p, false);
                    if (rand.nextInt(4) == 0 && world.setBlock(p, Blocks.SPAWNER.defaultBlockState(), 3) && (ms = (SpawnerBlockEntity)world.getBlockEntity(p)) != null) {
                        ms.setEntityId((EntityType)TFEntities.RISING_ZOMBIE.get(), rand);
                    }
                }
            }
        });
        return true;
    }

    private static enum GraveType {
        Full(TwilightForestMod.prefix("feature/graveyard/grave_full")),
        Upper(TwilightForestMod.prefix("feature/graveyard/grave_upper")),
        Lower(TwilightForestMod.prefix("feature/graveyard/grave_lower"));

        private static final GraveType[] VALUES;
        private final ResourceLocation RL;

        private GraveType(ResourceLocation rl) {
            this.RL = rl;
        }

        static {
            VALUES = GraveType.values();
        }
    }

    public static class WebTemplateProcessor
    extends StructureProcessor {
        public static final WebTemplateProcessor INSTANCE = new WebTemplateProcessor();
        public static final MapCodec<WebTemplateProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

        private WebTemplateProcessor() {
        }

        protected StructureProcessorType<?> getType() {
            return (StructureProcessorType)TFStructureProcessors.WEB.get();
        }

        @Nullable
        public StructureTemplate.StructureBlockInfo process(LevelReader worldIn, BlockPos pos, BlockPos piecepos, StructureTemplate.StructureBlockInfo p_process_3_, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
            return blockInfo.state().getBlock() == Blocks.GRASS_BLOCK ? blockInfo : (settings.getRandom(pos).nextInt(5) == 0 ? new StructureTemplate.StructureBlockInfo(pos, Blocks.COBWEB.defaultBlockState(), null) : blockInfo);
        }
    }
}

