/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.BlockTagGenerator;

public class TFSmallLakeFeature
extends Feature<Configuration> {
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public TFSmallLakeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockState barrierState;
        BlockPos blockpos = context.origin();
        WorldGenLevel worldgenlevel = context.level();
        RandomSource randomsource = context.random();
        Configuration config = (Configuration)context.config();
        if (blockpos.getY() <= worldgenlevel.getMinBuildHeight() + 4) {
            return false;
        }
        blockpos = blockpos.below(4);
        boolean[] booleans = new boolean[2048];
        int i = randomsource.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = randomsource.nextDouble() * 6.0 + 3.0;
            double d1 = randomsource.nextDouble() * 4.0 + 2.0;
            double d2 = randomsource.nextDouble() * 6.0 + 3.0;
            double d3 = randomsource.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = randomsource.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = randomsource.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        booleans[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState fluidState = config.fluid().getState(randomsource, blockpos);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 8; ++y) {
                    boolean flag;
                    boolean bl = flag = !booleans[(x * 16 + z) * 8 + y] && (x < 15 && booleans[((x + 1) * 16 + z) * 8 + y] || x > 0 && booleans[((x - 1) * 16 + z) * 8 + y] || z < 15 && booleans[(x * 16 + z + 1) * 8 + y] || z > 0 && booleans[(x * 16 + (z - 1)) * 8 + y] || y < 7 && booleans[(x * 16 + z) * 8 + y + 1] || y > 0 && booleans[(x * 16 + z) * 8 + (y - 1)]);
                    if (!flag) continue;
                    BlockState blockstate3 = worldgenlevel.getBlockState(blockpos.offset(x, y, z));
                    if (y >= 4 && blockstate3.liquid()) {
                        return false;
                    }
                    if (y >= 4 || blockstate3.isSolid() || worldgenlevel.getBlockState(blockpos.offset(x, y, z)) == fluidState) continue;
                    return false;
                }
            }
        }
        BlockState iceState = config.ice != null ? config.ice.getState(randomsource, blockpos) : null;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 8; ++y) {
                    BlockPos offset;
                    if (!booleans[(x * 16 + z) * 8 + y] || worldgenlevel.getBlockState(offset = blockpos.offset(x, y, z)).is(BlockTagGenerator.SMALL_LAKES_DONT_REPLACE) || worldgenlevel.getBlockState(offset.above()).is(BlockTagGenerator.SMALL_LAKES_DONT_REPLACE)) continue;
                    if (y >= 4) {
                        worldgenlevel.setBlock(offset, AIR, 2);
                        worldgenlevel.scheduleTick(offset, AIR.getBlock(), 0);
                        this.markAboveForPostProcessing(worldgenlevel, offset);
                        continue;
                    }
                    if (y == 3 && iceState != null) {
                        worldgenlevel.setBlock(offset, iceState, 2);
                        continue;
                    }
                    worldgenlevel.setBlock(offset, fluidState, 2);
                }
            }
        }
        if (config.barrier() != null && !(barrierState = config.barrier().getState(randomsource, blockpos)).isAir()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 8; ++y) {
                        BlockState blockstate;
                        boolean flag2;
                        boolean bl = flag2 = !booleans[(x * 16 + z) * 8 + y] && (x < 15 && booleans[((x + 1) * 16 + z) * 8 + y] || x > 0 && booleans[((x - 1) * 16 + z) * 8 + y] || z < 15 && booleans[(x * 16 + z + 1) * 8 + y] || z > 0 && booleans[(x * 16 + (z - 1)) * 8 + y] || y < 7 && booleans[(x * 16 + z) * 8 + y + 1] || y > 0 && booleans[(x * 16 + z) * 8 + (y - 1)]);
                        if (!flag2 || y >= 4 && randomsource.nextInt(2) == 0 || !(blockstate = worldgenlevel.getBlockState(blockpos.offset(x, y, z))).isSolid() || blockstate.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) continue;
                        BlockPos blockpos3 = blockpos.offset(x, y, z);
                        worldgenlevel.setBlock(blockpos3, barrierState, 2);
                        this.markAboveForPostProcessing(worldgenlevel, blockpos3);
                    }
                }
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider fluid, @Nullable BlockStateProvider barrier, @Nullable BlockStateProvider ice) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.CODEC.optionalFieldOf("barrier").forGetter(configuration -> Optional.ofNullable(configuration.barrier())), (App)BlockStateProvider.CODEC.optionalFieldOf("ice").forGetter(configuration -> Optional.ofNullable(configuration.ice()))).apply((Applicative)instance, Configuration::new));

        private Configuration(BlockStateProvider fluid, Optional<BlockStateProvider> barrier, Optional<BlockStateProvider> ice) {
            this(fluid, (BlockStateProvider)barrier.orElse(null), (BlockStateProvider)ice.orElse(null));
        }
    }
}

