/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.woods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import twilightforest.util.features.FeaturePlacers;

public class WoodPalette {
    public static final Codec<WoodPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("planks").forGetter(p -> p.planks), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("stairs").forGetter(p -> p.stairs), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("slab").forGetter(p -> p.slab), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("button").forGetter(p -> p.button), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("fence").forGetter(p -> p.fence), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("gate").forGetter(p -> p.gate), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plate").forGetter(p -> p.plate), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("banister").forGetter(p -> p.banister)).apply((Applicative)instance, WoodPalette::new));
    private final Set<Block> blocks;
    private final Block planks;
    private final Block stairs;
    private final Block slab;
    private final Block button;
    private final Block fence;
    private final Block gate;
    private final Block plate;
    private final Block banister;

    public WoodPalette(Holder<Block> planks, Holder<Block> stairs, Holder<Block> slab, Holder<Block> button, Holder<Block> fence, Holder<Block> gate, Holder<Block> plate, Holder<Block> banister) {
        this((Block)planks.value(), (Block)stairs.value(), (Block)slab.value(), (Block)button.value(), (Block)fence.value(), (Block)gate.value(), (Block)plate.value(), (Block)banister.value());
    }

    public WoodPalette(Block planks, Block stairs, Block slab, Block button, Block fence, Block gate, Block plate, Block banister) {
        this.planks = planks;
        this.stairs = stairs;
        this.slab = slab;
        this.button = button;
        this.fence = fence;
        this.gate = gate;
        this.plate = plate;
        this.banister = banister;
        this.blocks = new HashSet<Block>(List.of(this.planks, this.stairs, this.slab, this.button, this.fence, this.gate, this.plate, this.banister));
    }

    public boolean contains(Block block) {
        return this.blocks.contains(block);
    }

    public StructureTemplate.StructureBlockInfo modifyBlockWithType(WoodPalette targetPalette, StructureTemplate.StructureBlockInfo state) {
        BlockState newState = state.state();
        if (targetPalette.contains(newState.getBlock())) {
            return new StructureTemplate.StructureBlockInfo(state.pos(), this.modifyBlockWithType(targetPalette, newState), state.nbt());
        }
        return state;
    }

    public BlockState modifyBlockWithType(WoodPalette targetPalette, BlockState state) {
        return switch (targetPalette.getWoodShapeFromBlock(state.getBlock()).ordinal()) {
            case 0 -> this.planks.defaultBlockState();
            case 1 -> FeaturePlacers.transferAllStateKeys(state, this.stairs);
            case 2 -> FeaturePlacers.transferAllStateKeys(state, this.slab);
            case 4 -> FeaturePlacers.transferAllStateKeys(state, this.fence);
            case 5 -> FeaturePlacers.transferAllStateKeys(state, this.gate);
            case 3 -> FeaturePlacers.transferAllStateKeys(state, this.button);
            case 6 -> FeaturePlacers.transferAllStateKeys(state, this.plate);
            case 7 -> FeaturePlacers.transferAllStateKeys(state, this.banister);
            default -> state;
        };
    }

    public WoodShapes getWoodShapeFromBlock(Block b) {
        if (b == this.planks) {
            return WoodShapes.BLOCK;
        }
        if (b == this.stairs) {
            return WoodShapes.STAIRS;
        }
        if (b == this.slab) {
            return WoodShapes.SLAB;
        }
        if (b == this.button) {
            return WoodShapes.BUTTON;
        }
        if (b == this.fence) {
            return WoodShapes.FENCE;
        }
        if (b == this.gate) {
            return WoodShapes.GATE;
        }
        if (b == this.plate) {
            return WoodShapes.PLATE;
        }
        if (b == this.banister) {
            return WoodShapes.BANISTER;
        }
        return WoodShapes.INVALID;
    }

    public static enum WoodShapes {
        BLOCK,
        STAIRS,
        SLAB,
        BUTTON,
        FENCE,
        GATE,
        PLATE,
        BANISTER,
        INVALID;

    }
}

