/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.init.TFDataAttachments;

public record UpdateShieldPacket(int entityID, int temporaryShields, int permanentShields) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateShieldPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("update_shield_attachment"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateShieldPacket> STREAM_CODEC = CustomPacketPayload.codec(UpdateShieldPacket::write, UpdateShieldPacket::new);

    public UpdateShieldPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeInt(this.temporaryShields());
        buf.writeInt(this.permanentShields());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final UpdateShieldPacket message, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = ctx.player().level().getEntity(message.entityID);
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        FortificationShieldAttachment attachment = (FortificationShieldAttachment)living.getData(TFDataAttachments.FORTIFICATION_SHIELDS);
                        attachment.setShields(living, message.temporaryShields, true);
                        attachment.setShields(living, message.permanentShields, false);
                    }
                }
            });
        }
    }
}

