/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import twilightforest.enchantment.RechargeScepterEffect;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.util.TFItemStackUtils;

public class ZombieWandItem
extends Item {
    public ZombieWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult result;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() == stack.getMaxDamage() && !player.getAbilities().instabuild) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide() && (result = ZombieWandItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).getType() != HitResult.Type.MISS) {
            LoyalZombie zombie = (LoyalZombie)((EntityType)TFEntities.LOYAL_ZOMBIE.get()).create(level);
            zombie.moveTo(result.getLocation());
            if (!level.noCollision((Entity)zombie, zombie.getBoundingBox())) {
                return InteractionResultHolder.pass((Object)stack);
            }
            zombie.spawnAnim();
            zombie.setTame(true, false);
            zombie.setOwnerUUID(player.getUUID());
            zombie.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 1));
            if (player.getItemBySlot(EquipmentSlot.HEAD).is(TFItems.MYSTIC_CROWN) && level.getRandom().nextFloat() <= 0.1f) {
                zombie.setBaby(true);
            }
            level.addFreshEntity((Entity)zombie);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, result.getBlockPos());
            if (!player.getAbilities().instabuild) {
                TFItemStackUtils.hurtButDontBreak(stack, 1, (ServerLevel)level, (LivingEntity)player);
            }
            zombie.playSound((SoundEvent)TFSounds.ZOMBIE_SCEPTER_USE.get(), 1.0f, 1.0f);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity.tickCount % 20 == 0 && level instanceof ServerLevel) {
            int renewal;
            ServerLevel serverLevel = (ServerLevel)level;
            if (stack.has(DataComponents.ENCHANTMENTS) && !isSelected && (renewal = ((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).getLevel(level.holderOrThrow(TFEnchantments.RENEWAL))) > 0) {
                RechargeScepterEffect.applyRecharge(serverLevel, stack, entity);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.twilightforest.scepter.desc", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}).withStyle(ChatFormatting.GRAY));
    }
}

