/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.init.TFDataMaps;
import twilightforest.util.datamaps.EntityTransformation;
import twilightforest.util.entities.EntityUtil;

public class TransformPowderItem
extends Item {
    public TransformPowderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!target.isAlive()) {
            return InteractionResult.PASS;
        }
        return TransformPowderItem.transformEntityIfPossible(target, player.getItemInHand(hand), !player.isCreative()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        if (level.isClientSide()) {
            AABB area = this.getEffectAABB(player);
            for (int i = 0; i < 30; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.CRIT, area.minX + (double)level.getRandom().nextFloat() * (area.maxX - area.minX), area.minY + (double)level.getRandom().nextFloat() * (area.maxY - area.minY), area.minZ + (double)level.getRandom().nextFloat() * (area.maxZ - area.minZ), 0.0, 0.0, 0.0);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public static boolean transformEntityIfPossible(LivingEntity target, ItemStack powder, boolean shrinkStack) {
        OwnableEntity ownable;
        if (target instanceof OwnableEntity && (ownable = (OwnableEntity)target).getOwner() != null) {
            return false;
        }
        EntityTransformation datamap = (EntityTransformation)target.getType().builtInRegistryHolder().getData(TFDataMaps.TRANSFORMATION_POWDER);
        if (datamap != null) {
            boolean flag = EntityUtil.convertEntity(target, datamap.result());
            if (flag && shrinkStack) {
                powder.shrink(1);
            }
            return flag;
        }
        return false;
    }

    private AABB getEffectAABB(Player player) {
        double range = 2.0;
        double radius = 1.0;
        Vec3 srcVec = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 lookVec = player.getLookAngle();
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        return new AABB(destVec.x() - radius, destVec.y() - radius, destVec.z() - radius, destVec.x() + radius, destVec.y() + radius, destVec.z() + radius);
    }
}

