/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import twilightforest.TFRegistries;
import twilightforest.init.custom.DwarfRabbitVariants;

public record DwarfRabbitVariant(ResourceLocation texture, Optional<HolderSet<Biome>> spawnBiomes) {
    public static final Codec<DwarfRabbitVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(DwarfRabbitVariant::texture), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(DwarfRabbitVariant::spawnBiomes)).apply((Applicative)p_332779_, DwarfRabbitVariant::new));
    public static final Codec<Holder<DwarfRabbitVariant>> CODEC = RegistryFileCodec.create(TFRegistries.Keys.DWARF_RABBIT_VARIANT, DIRECT_CODEC);

    public DwarfRabbitVariant(ResourceLocation texture) {
        this(texture, Optional.empty());
    }

    public static Holder<DwarfRabbitVariant> getVariant(RegistryAccess access, Holder<Biome> currentBiome, RandomSource random) {
        Registry registry = access.registryOrThrow(TFRegistries.Keys.DWARF_RABBIT_VARIANT);
        List<Holder.Reference> validBunnies = registry.holders().filter(variant -> ((DwarfRabbitVariant)variant.value()).spawnBiomes().isEmpty() || ((DwarfRabbitVariant)variant.value()).spawnBiomes().get().contains(currentBiome)).toList();
        return validBunnies.isEmpty() ? registry.getHolderOrThrow(DwarfRabbitVariants.BROWN) : (Holder)validBunnies.get(random.nextInt(validBunnies.size()));
    }

    public static Holder<DwarfRabbitVariant> getRandomCommonVariant(RegistryAccess access, RandomSource random) {
        Registry registry = access.registryOrThrow(TFRegistries.Keys.DWARF_RABBIT_VARIANT);
        List<Holder.Reference> validBunnies = registry.holders().filter(variant -> ((DwarfRabbitVariant)variant.value()).spawnBiomes().isEmpty()).toList();
        return validBunnies.isEmpty() ? registry.getHolderOrThrow(DwarfRabbitVariants.BROWN) : (Holder)validBunnies.get(random.nextInt(validBunnies.size()));
    }
}

