/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.goal.BreathAttackGoal;
import twilightforest.entity.monster.HostileWolf;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class WinterWolf
extends HostileWolf
implements IBreathAttacker {
    private static final EntityDataAccessor<Boolean> BREATH_FLAG = SynchedEntityData.defineId(WinterWolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float BREATH_DAMAGE = 2.0f;

    public WinterWolf(EntityType<? extends WinterWolf> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new BreathAttackGoal<WinterWolf>(this, 5.0f, 30, 0.1f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return HostileWolf.registerAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BREATH_FLAG, (Object)false);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isBreathing()) {
            if (this.level().isClientSide()) {
                this.spawnBreathParticles();
            }
            this.playBreathSound();
        }
    }

    private void spawnBreathParticles() {
        Vec3 look = this.getLookAngle();
        double dist = 0.5;
        double px = this.getX() + look.x() * 0.5;
        double py = this.getY() + 1.25 + look.y() * 0.5;
        double pz = this.getZ() + look.z() * 0.5;
        for (int i = 0; i < 10; ++i) {
            double dx = look.x();
            double dy = look.y();
            double dz = look.z();
            double spread = 5.0 + this.getRandom().nextDouble() * 2.5;
            double velocity = 3.0 + this.getRandom().nextDouble() * 0.15;
            dx += this.getRandom().nextGaussian() * 0.0075 * spread;
            dy += this.getRandom().nextGaussian() * 0.0075 * spread;
            dz += this.getRandom().nextGaussian() * 0.0075 * spread;
            this.level().addParticle((ParticleOptions)TFParticleType.SNOW.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }

    @Override
    protected SoundEvent getTargetSound() {
        return (SoundEvent)TFSounds.WINTER_WOLF_TARGET.get();
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.WINTER_WOLF_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)TFSounds.WINTER_WOLF_HURT.get();
    }

    private void playBreathSound() {
        this.playSound((SoundEvent)TFSounds.WINTER_WOLF_SHOOT.get(), this.getRandom().nextFloat() * 0.5f, this.getRandom().nextFloat() * 0.5f);
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.WINTER_WOLF_DEATH.get();
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.6f;
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.getEntityData().get(BREATH_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.getEntityData().set(BREATH_FLAG, (Object)flag);
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f);
    }

    public static boolean canSpawnHere(EntityType<? extends WinterWolf> entity, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        Optional key = accessor.getBiome(pos).unwrapKey();
        return accessor.getDifficulty() != Difficulty.PEACEFUL && Objects.equals(key, Optional.of(TFBiomes.SNOWY_FOREST)) || Monster.isDarkEnoughToSpawn((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }
}

