/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import twilightforest.entity.monster.HostileWolf;
import twilightforest.init.TFSounds;

public class MistWolf
extends HostileWolf {
    public MistWolf(EntityType<? extends MistWolf> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return HostileWolf.registerAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            float myBrightness = this.level().getMaxLocalRawBrightness(this.blockPosition());
            if (entity instanceof LivingEntity && myBrightness < 0.1f) {
                int effectDuration;
                switch (this.level().getDifficulty()) {
                    case EASY: {
                        int n = 0;
                        break;
                    }
                    case HARD: {
                        int n = 15;
                        break;
                    }
                    default: {
                        int n = effectDuration = 7;
                    }
                }
                if (effectDuration > 0 && !this.level().getBlockState(this.blockPosition()).isSolid()) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, effectDuration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getTargetSound() {
        return (SoundEvent)TFSounds.MIST_WOLF_TARGET.get();
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.MIST_WOLF_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)TFSounds.MIST_WOLF_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.MIST_WOLF_DEATH.get();
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.6f;
    }
}

