/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraPart;

public class HydraHead
extends HydraPart {
    public static final ResourceLocation RENDERER = TwilightForestMod.prefix("hydra_head");
    private static final EntityDataAccessor<Float> DATA_MOUTH_POSITION = SynchedEntityData.defineId(HydraHead.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_MOUTH_POSITION_LAST = SynchedEntityData.defineId(HydraHead.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Byte> DATA_STATE = SynchedEntityData.defineId(HydraHead.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public HydraHead(Hydra hydra) {
        super(hydra, 4.0f, 4.0f);
    }

    @Override
    public ResourceLocation renderer() {
        return RENDERER;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_MOUTH_POSITION, (Object)Float.valueOf(0.0f));
        builder.define(DATA_MOUTH_POSITION_LAST, (Object)Float.valueOf(0.0f));
        builder.define(DATA_STATE, (Object)0);
    }

    public float getMouthOpen() {
        return ((Float)this.getEntityData().get(DATA_MOUTH_POSITION)).floatValue();
    }

    public float getMouthOpenLast() {
        return ((Float)this.getEntityData().get(DATA_MOUTH_POSITION_LAST)).floatValue();
    }

    public HydraHeadContainer.State getState() {
        return HydraHeadContainer.State.values()[(Byte)this.getEntityData().get(DATA_STATE)];
    }

    public void setMouthOpen(float openness) {
        this.getEntityData().set(DATA_MOUTH_POSITION_LAST, (Object)Float.valueOf(this.getMouthOpen()));
        this.getEntityData().set(DATA_MOUTH_POSITION, (Object)Float.valueOf(openness));
    }

    public void setState(HydraHeadContainer.State state) {
        this.getEntityData().set(DATA_STATE, (Object)((byte)state.ordinal()));
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Component tagName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (stack.is(Items.NAME_TAG) && tagName != null) {
            if (!this.level().isClientSide() && this.isAlive()) {
                this.setCustomName(tagName);
                stack.shrink(1);
                Hydra hydra = (Hydra)this.getParent();
                if (hydra != null) {
                    for (int i = 0; i < 7; ++i) {
                        if (hydra.hc[i].headEntity != this) continue;
                        hydra.setHeadNameFor(i, tagName.getString());
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.interact(player, hand);
    }
}

