/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;

public class FireflyParticle
extends TextureSheetParticle {
    private final int halfLife;
    private final boolean checkSkylight;

    public FireflyParticle(ClientLevel level, double x, double y, double z, float movementX, float movementY, float movementZ, int minlife, boolean checkSkylight) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)movementX;
        this.yd *= (double)movementY;
        this.zd *= (double)movementZ;
        this.rCol = 0.5f + this.random.nextFloat() * 0.25f;
        this.gCol = 0.85f - this.random.nextFloat() * 0.25f;
        this.bCol = 0.0f;
        this.quadSize = 0.2f + this.random.nextFloat() * 0.1f;
        this.lifetime = minlife + this.random.nextInt(21);
        this.halfLife = this.lifetime / 2;
        this.hasPhysics = true;
        this.checkSkylight = checkSkylight;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        this.alpha = this.getGlowBrightness();
        super.render(buffer, camera, partialTicks);
    }

    public void tick() {
        if (this.checkSkylight && this.level.getBrightness(LightLayer.SKY, BlockPos.containing((double)this.x, (double)this.y, (double)this.z)) <= 12) {
            this.remove();
        }
        super.tick();
    }

    public float getGlowBrightness() {
        int lifeTime = this.lifetime - this.age;
        if (lifeTime <= this.halfLife) {
            return (float)lifeTime / (float)this.halfLife;
        }
        return Math.max(1.0f - ((float)lifeTime - (float)this.halfLife) / (float)this.halfLife, 0.0f);
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public record ParticleSpawnerProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.1f, 0.1f, 0.1f, 30, false);
            RandomSource rand = level.getRandom();
            particle.xd += (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            particle.yd += (double)rand.nextFloat() * -0.25 * (double)rand.nextFloat() * 0.1;
            particle.zd += (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            particle.pickSprite(this.sprite());
            return particle;
        }
    }

    public record WanderingProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.1f, 0.1f, 0.1f, 30, true);
            RandomSource rand = level.getRandom();
            particle.xd += (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            particle.yd += (double)rand.nextFloat() * -0.25 * (double)rand.nextFloat() * 0.1;
            particle.zd += (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            particle.pickSprite(this.sprite());
            return particle;
        }
    }

    public record StationaryProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.0f, 0.0f, 0.0f, 10, false);
            particle.pickSprite(this.sprite());
            return particle;
        }
    }
}

