/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.block.GhastTrapBlock;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class GhastTrapBlockEntity
extends BlockEntity {
    private final List<CarminiteGhastling> dyingGhasts = new ArrayList<CarminiteGhastling>();
    private final RandomSource rand = RandomSource.create();
    private int counter = 0;

    public GhastTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.GHAST_TRAP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        if (!level.isDebug()) {
            if (((Boolean)state.getValue((Property)GhastTrapBlock.ACTIVE)).booleanValue()) {
                te.tickActive(level, pos, state, te);
            } else {
                te.tickInactive(level, pos, state, te);
            }
        }
    }

    private void tickInactive(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        AABB aabb = new AABB(pos).inflate(10.0, 16.0, 10.0);
        List nearbyGhasts = level.getEntitiesOfClass(CarminiteGhastling.class, aabb);
        for (CarminiteGhastling ghast : nearbyGhasts) {
            if (ghast.deathTime <= 0) continue;
            te.makeParticlesTo(level, ghast.getEyePosition());
            if (te.dyingGhasts.contains(ghast)) continue;
            te.dyingGhasts.add(ghast);
        }
        int chargeLevel = Math.min(3, te.dyingGhasts.size());
        ++te.counter;
        if (level.isClientSide()) {
            if (te.counter % 20 == 0 && !nearbyGhasts.isEmpty()) {
                te.makeParticlesTo(level, ((CarminiteGhastling)nearbyGhasts.get(te.rand.nextInt(nearbyGhasts.size()))).getEyePosition());
            }
            if (chargeLevel >= 1 && te.counter % 10 == 0) {
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (chargeLevel >= 2) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)pos.getY() + 1.05, (double)pos.getZ() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05, 0.0, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05);
                if (te.counter % 10 == 0) {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.2f, 0.8f, false);
                }
            }
            if (chargeLevel == 3) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)pos.getY() + 1.05, (double)pos.getZ() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05, 0.05, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05);
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                if (te.counter % 5 == 0) {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.5f, 2.0f, false);
                }
            }
        }
    }

    private void makeParticlesTo(Level level, Vec3 to) {
        Vec3 top = Vec3.atBottomCenterOf((Vec3i)this.getBlockPos().above());
        Vec3 diff = top.subtract(to);
        for (int i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), top.x, top.y, top.z, -diff.x, -diff.y, -diff.z);
        }
    }

    public boolean isCharged() {
        return this.dyingGhasts.size() >= 3;
    }

    public boolean triggerEvent(int event, int payload) {
        if (event == 0) {
            this.counter = 0;
            this.dyingGhasts.clear();
            return true;
        }
        if (event == 1) {
            this.counter = 0;
            return true;
        }
        return false;
    }

    private void tickActive(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        ++te.counter;
        if (level.isClientSide()) {
            if (te.counter > 100 && te.counter % 4 == 0) {
                level.addParticle((ParticleOptions)TFParticleType.HUGE_SMOKE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.95, (double)pos.getZ() + 0.5, Math.cos((double)te.counter / 10.0) * 0.05, 0.25, Math.sin((double)te.counter / 10.0) * 0.05);
            } else if (te.counter < 100) {
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 1.0;
                double z = (double)pos.getZ() + 0.5;
                double dx = Math.cos((double)te.counter / 10.0) * 2.5;
                double dy = 20.0;
                double dz = Math.sin((double)te.counter / 10.0) * 2.5;
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy, dz);
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy, -dz);
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy / 2.0, dz);
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy / 2.0, -dz);
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx / 2.0, dy / 4.0, dz / 2.0);
                level.addParticle((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx / 2.0, dy / 4.0, -dz / 2.0);
            }
            if (te.counter < 30) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_WARMUP.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            } else if (te.counter < 80) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_ON.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            } else {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_SPINDOWN.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            }
        } else {
            AABB aabb = new AABB(pos.above(16).getCenter(), pos.above(16).offset(1, 1, 1).getCenter()).inflate(6.0, 16.0, 6.0);
            List nearbyGhasts = level.getEntitiesOfClass(Mob.class, aabb, mob -> mob instanceof Ghast || mob instanceof UrGhast);
            for (Mob ghast : nearbyGhasts) {
                double mz;
                double my;
                double mx;
                if (ghast instanceof UrGhast) {
                    UrGhast urghast = (UrGhast)ghast;
                    urghast.setInTantrum(false);
                    urghast.setInTrap();
                    ghast.noPhysics = true;
                    mx = (ghast.getX() - (double)pos.getX() - 0.5) * -0.1;
                    my = (ghast.getY() - (double)pos.getY() - 2.5) * -0.1;
                    mz = (ghast.getZ() - (double)pos.getZ() - 0.5) * -0.1;
                    ghast.setDeltaMovement(mx, my, mz);
                    if (te.rand.nextInt(10) != 0) continue;
                    ghast.hurt(level.damageSources().generic(), 7.0f);
                    urghast.resetDamageUntilNextPhase();
                    continue;
                }
                mx = (ghast.getX() - (double)pos.getX() - 0.5) * -0.1;
                my = (ghast.getY() - (double)pos.getY() - 1.5) * -0.1;
                mz = (ghast.getZ() - (double)pos.getZ() - 0.5) * -0.1;
                ghast.setDeltaMovement(mx, my, mz);
                if (te.rand.nextInt(10) != 0) continue;
                ghast.hurt(level.damageSources().generic(), 10.0f);
            }
            if (te.counter >= 120) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                level.blockEvent(pos, state.getBlock(), 1, 0);
            }
        }
    }
}

