/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import quek.undergarden.registry.UGAttachments;

public class RogdoriumItem
extends Item {
    private final float percentage;

    public RogdoriumItem(float percentage, Item.Properties properties) {
        super(properties);
        this.percentage = percentage;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if ((Double)player.getData(UGAttachments.UTHERIC_INFECTION) > 0.0) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (Double)(player = (Player)entity).getData(UGAttachments.UTHERIC_INFECTION) > 0.0) {
            player.setData(UGAttachments.UTHERIC_INFECTION, (Object)Math.max(0.0, (Double)player.getData(UGAttachments.UTHERIC_INFECTION) - 20.0 * (double)this.percentage));
        }
        return entity.eat(level, stack, new FoodProperties.Builder().build());
    }
}

