/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.inventory;

import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import quek.undergarden.inventory.slot.InfuserResultSlot;
import quek.undergarden.inventory.slot.InfuserRogdoriumFuelSlot;
import quek.undergarden.inventory.slot.InfuserUtheriumFuelSlot;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGMenuTypes;
import quek.undergarden.registry.UGRecipeBookTypes;
import quek.undergarden.registry.UGRecipeTypes;
import quek.undergarden.registry.UGTags;

public class InfuserMenu
extends RecipeBookMenu<SingleRecipeInput, InfusingRecipe> {
    private final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<InfusingRecipe> recipeType = (RecipeType)UGRecipeTypes.INFUSING.get();

    public InfuserMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(2));
    }

    public InfuserMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)UGMenuTypes.INFUSER.get(), containerId);
        InfuserMenu.checkContainerSize((Container)container, (int)4);
        InfuserMenu.checkContainerDataCount((ContainerData)data, (int)2);
        this.container = container;
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(container, 0, 80, 17));
        this.addSlot(new InfuserUtheriumFuelSlot(this, container, 1, 26, 53));
        this.addSlot(new InfuserRogdoriumFuelSlot(this, container, 2, 134, 53));
        this.addSlot(new InfuserResultSlot(playerInventory.player, container, 3, 80, 52));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean isUtheriumFuel(ItemStack stack) {
        return stack.is(UGTags.Items.INFUSER_UTHERIUM_FUELS);
    }

    public boolean isUtheriumFuelFull() {
        return !this.container.getItem(1).isEmpty();
    }

    public boolean isRogdoriumFuel(ItemStack stack) {
        return stack.is(UGTags.Items.INFUSER_ROGDORIUM_FUELS);
    }

    public boolean isRogdoriumFuelFull() {
        return !this.container.getItem(2).isEmpty();
    }

    public float getInfusingProgress() {
        int infusingProgress = this.getInfusingProgressInt();
        int infusingTotalTime = this.getInfusingTotalTimeInt();
        return infusingProgress != 0 && infusingTotalTime != 0 ? Mth.clamp((float)((float)infusingProgress / (float)infusingTotalTime), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public int getInfusingProgressInt() {
        return this.data.get(0);
    }

    public int getInfusingTotalTimeInt() {
        return this.data.get(1);
    }

    protected boolean canInfuse(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelper) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(itemHelper);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
        this.getSlot(2).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<InfusingRecipe> recipe) {
        return ((InfusingRecipe)recipe.value()).matches((RecipeInput)new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return 3;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 4;
    }

    public RecipeBookType getRecipeBookType() {
        return UGRecipeBookTypes.INFUSER;
    }

    public boolean shouldMoveToInventory(int slotIndex) {
        return slotIndex != 1 && slotIndex != 2;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 3) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 1 && index != 0 && index != 2 ? (this.canInfuse(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (this.isUtheriumFuel(itemstack1) && ((Slot)this.slots.get(2)).getItem().isEmpty() ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (this.isRogdoriumFuel(itemstack1) && ((Slot)this.slots.get(1)).getItem().isEmpty() ? !this.moveItemStackTo(itemstack1, 2, 3, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

