/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGDataComponents;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGTags;

public class RotbelcherProjectile
extends AbstractHurtingProjectile {
    public RotbelcherProjectile(EntityType<? extends RotbelcherProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public RotbelcherProjectile(Level level, LivingEntity owner, Vec3 movement) {
        super((EntityType)UGEntityTypes.ROTBELCHER_PROJECTILE.get(), owner, movement, level);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity victim = result.getEntity();
            Entity shooter = this.getOwner();
            LivingEntity livingShooter = shooter instanceof LivingEntity ? (LivingEntity)shooter : null;
            DamageSource damageSource = this.damageSources().spit((Entity)this, livingShooter);
            if (victim.hurt(damageSource, 5.0f)) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)victim, (DamageSource)damageSource);
                if (victim instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)victim;
                    if (!this.level().isClientSide() && !livingEntity.getType().is(UGTags.Entities.IMMUNE_TO_INFECTION)) {
                        double data = (Double)livingEntity.getData(UGAttachments.UTHERIC_INFECTION);
                        double b = 0.2;
                        int a = 0;
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            for (int i = 0; i < 4; ++i) {
                                ItemStack armor = player.getInventory().getArmor(i);
                                int infusionAmount = ((RogdoriumInfusion)armor.getOrDefault(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.DEFAULT)).infusionAmount();
                                if (infusionAmount <= 0) continue;
                                armor.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(infusionAmount - 1));
                                ++a;
                            }
                        }
                        double t = b / ((double)(1 + a) * 0.18);
                        livingEntity.setData(UGAttachments.UTHERIC_INFECTION, (Object)(data + t));
                    }
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)UGItems.UTHERIUM_CRYSTAL.get()));
    }

    public boolean canCollideWith(Entity entity) {
        return !entity.getType().is(UGTags.Entities.ROTSPAWN) && super.canCollideWith(entity);
    }

    protected boolean canHitEntity(Entity target) {
        return !target.getType().is(UGTags.Entities.ROTSPAWN) && super.canHitEntity(target);
    }
}

