/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.stoneborn;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.slf4j.Logger;
import quek.undergarden.criterion.StonebornTradeTrigger;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGSoundEvents;

public abstract class AbstractStoneborn
extends Monster
implements Npc,
Merchant {
    protected int timeOutOfUG = 0;
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;

    public AbstractStoneborn(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAggressive()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_ANGRY.get();
        }
        if (this.isTrading()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_SPEAKING.get();
        }
        if (!this.inUndergarden()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.STONEBORN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.STONEBORN_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.STONEBORN_STEP.get(), 1.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        if (!this.inUndergarden() && !this.isNoAi()) {
            ++this.timeOutOfUG;
            this.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 300, 0));
        } else {
            this.timeOutOfUG = 0;
        }
        if (this.timeOutOfUG >= 300) {
            this.playSound((SoundEvent)UGSoundEvents.STONEBORN_CHANT.get(), 1.0f, 1.0f);
            if (!this.level().isClientSide()) {
                this.remove(Entity.RemovalReason.KILLED);
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
            }
        }
    }

    public boolean inUndergarden() {
        return this.level().dimension() == UGDimensions.UNDERGARDEN_LEVEL;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public int getVillagerXp() {
        return 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers getOffers() {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void overrideXp(int xp) {
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.rewardTradeXp(offer);
        if (this.tradingPlayer instanceof ServerPlayer) {
            ((StonebornTradeTrigger)((Object)UGCriteria.STONEBORN_TRADE.get())).trigger((ServerPlayer)this.tradingPlayer, this, offer.getResult());
        }
    }

    protected abstract void rewardTradeXp(MerchantOffer var1);

    public boolean showProgressBar() {
        return true;
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.makeSound(this.getTradeUpdatedSound(!stack.isEmpty()));
        }
    }

    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean isYesSound) {
        return isYesSound ? (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get() : (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
    }

    public void playCelebrateSound() {
        this.makeSound((SoundEvent)UGSoundEvents.STONEBORN_CHANT.get());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        MerchantOffers merchantoffers;
        super.addAdditionalSaveData(compound);
        if (!this.level().isClientSide && !(merchantoffers = this.getOffers()).isEmpty()) {
            compound.put("Offers", (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)merchantoffers).getOrThrow());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Offers")) {
            MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("Offers")).resultOrPartial(Util.prefix((String)"Failed to load offers: ", arg_0 -> ((Logger)LOGGER).warn(arg_0))).ifPresent(offers -> {
                this.offers = offers;
            });
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        this.stopTrading();
        return super.changeDimension(transition);
    }

    protected void stopTrading() {
        this.setTradingPlayer(null);
    }

    public void die(DamageSource cause) {
        super.die(cause);
        this.stopTrading();
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOption, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected abstract void updateTrades();

    protected void addOffersFromItemListings(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        ArrayList arraylist = Lists.newArrayList((Object[])newTrades);
        int i = 0;
        while (i < maxNumbers && !arraylist.isEmpty()) {
            MerchantOffer merchantoffer = ((VillagerTrades.ItemListing)arraylist.remove(this.random.nextInt(arraylist.size()))).getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
            ++i;
        }
    }

    public Vec3 getRopeHoldPosition(float partialTicks) {
        float f = Mth.lerp((float)partialTicks, (float)this.yBodyRotO, (float)this.yBodyRot) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.getBoundingBox().getYsize() - 1.0, 0.2);
        return this.getPosition(partialTicks).add(vec3.yRot(-f));
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }
}

