/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.rotspawn;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import quek.undergarden.entity.monster.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGSoundEvents;

public class Rotbeast
extends RotspawnMonster {
    private int attackTimer;

    public Rotbeast(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Rotbeast.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.ARMOR, 3.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.ROTBEAST_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.ROTBEAST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.ROTBEAST_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.ROTBEAST_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean doHurtTarget(Entity entity) {
        this.attackTimer = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.getRandom().nextInt((int)f) : f;
        boolean flag = entity.hurt(this.damageSources().mobAttack((LivingEntity)this), f1);
        if (flag) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.4f, 0.0));
        }
        this.playSound((SoundEvent)UGSoundEvents.ROTBEAST_ATTACK.get(), 1.0f, 1.0f);
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.playSound((SoundEvent)UGSoundEvents.ROTBEAST_ATTACK.get(), 1.0f, 1.0f);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }
}

