/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.entity.monster.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;

public class Forgotten
extends Monster {
    public Forgotten(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        Arrays.fill(this.armorDropChances, 0.03f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, RotspawnMonster.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ARMOR, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.FORGOTTEN_STEP.get(), 0.15f, 1.0f);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        ServerLevel level = this.getServer().getLevel(this.level().dimension());
        Structure structure = (Structure)level.structureManager().registryAccess().registryOrThrow(Registries.STRUCTURE).get(UGStructures.DEPLETED_MINE);
        if (structure != null && level.getLevel().structureManager().getStructureAt(this.getOnPos(), structure).isValid() && this.getY() <= 0.0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.FORGOTTEN_PICKAXE.get()));
            this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)UGItems.CLOGGRUM_CHESTPLATE.get()));
        } else if (random.nextInt(50) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_BATTLEAXE.get()));
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)UGItems.ANCIENT_HELMET.get()));
            this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)UGItems.ANCIENT_CHESTPLATE.get()));
            this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)UGItems.ANCIENT_LEGGINGS.get()));
            this.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || !this.getItemBySlot(slot).isEmpty() || !random.nextBoolean()) continue;
                Item armor = switch (slot) {
                    case EquipmentSlot.HEAD -> (Item)UGItems.ANCIENT_HELMET.get();
                    case EquipmentSlot.CHEST -> (Item)UGItems.ANCIENT_CHESTPLATE.get();
                    case EquipmentSlot.LEGS -> (Item)UGItems.ANCIENT_LEGGINGS.get();
                    default -> Items.AIR;
                };
                this.setItemSlot(slot, new ItemStack((ItemLike)armor));
            }
            if (random.nextBoolean()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_SWORD.get()));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_AXE.get()));
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(accessor, difficulty, type, data);
        this.populateDefaultEquipmentSlots(accessor.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(accessor, accessor.getRandom(), difficulty);
        return data;
    }

    public boolean canPickUpLoot() {
        return false;
    }
}

