/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import quek.undergarden.registry.UGCriteria;

public class UthericInfectionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, double infectionLevel) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(infectionLevel));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<MinMaxBounds.Doubles> infectionLevel) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("infectionLevel").forGetter(TriggerInstance::infectionLevel)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<?> isInfected() {
            return ((UthericInfectionTrigger)((Object)UGCriteria.UTHERIC_INFECTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(MinMaxBounds.Doubles.atLeast((double)1.0))));
        }

        public static Criterion<?> hasInfectionLevel(int infectionLevel) {
            return ((UthericInfectionTrigger)((Object)UGCriteria.UTHERIC_INFECTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(MinMaxBounds.Doubles.exactly((double)infectionLevel))));
        }

        public static Criterion<?> hasInfectionLevel(MinMaxBounds.Doubles infectionLevel) {
            return ((UthericInfectionTrigger)((Object)UGCriteria.UTHERIC_INFECTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(infectionLevel)));
        }

        public boolean matches(double infectionLevel) {
            return this.infectionLevel.isEmpty() || this.infectionLevel.get().matches(infectionLevel);
        }
    }
}

