/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.compat.jade;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.compat.jade.ForgottenToolHandler;
import quek.undergarden.entity.animal.MysteriousPot;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public class UndergardenJadeCompat
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.addRayTraceCallback(this::createOverrides);
        HarvestToolProvider.registerHandler((ToolHandler)new ForgottenToolHandler(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"forgotten"), Lists.transform(List.of((Item)UGItems.FORGOTTEN_PICKAXE.get(), (Item)UGItems.FORGOTTEN_AXE.get(), (Item)UGItems.FORGOTTEN_SHOVEL.get(), (Item)UGItems.FORGOTTEN_HOE.get()), Item::getDefaultInstance)));
    }

    @Nullable
    private Accessor<?> createOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        MysteriousPot pot;
        EntityAccessor entity;
        Entity entity2;
        if (accessor instanceof EntityAccessor && (entity2 = (entity = (EntityAccessor)accessor).getEntity()) instanceof MysteriousPot && !(pot = (MysteriousPot)entity2).isActive()) {
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            return client.blockAccessor().level(entity.getLevel()).hit(new BlockHitResult(hitResult.getLocation(), pot.getNearestViewDirection(), pot.blockPosition(), false)).blockState(((Block)UGBlocks.DEPTHROCK_POT.get()).defaultBlockState()).build();
        }
        return accessor;
    }
}

