/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import quek.undergarden.Undergarden;
import quek.undergarden.client.model.RotbeastModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.layer.BasicEyesLayer;
import quek.undergarden.entity.monster.rotspawn.Rotbeast;

public class RotbeastRenderer
extends MobRenderer<Rotbeast, RotbeastModel<Rotbeast>> {
    private static final ResourceLocation ROTBEAST = Undergarden.prefix("textures/entity/rotbeast.png");
    private static final RenderType ROTBEAST_EYES = RenderType.eyes((ResourceLocation)Undergarden.prefix("textures/entity/rotbeast_eyes.png"));

    public RotbeastRenderer(EntityRendererProvider.Context context) {
        super(context, new RotbeastModel(context.bakeLayer(UGModelLayers.ROTBEAST)), 0.6f);
        this.addLayer((RenderLayer)new BasicEyesLayer(this, ROTBEAST_EYES));
    }

    public ResourceLocation getTextureLocation(Rotbeast entity) {
        return ROTBEAST;
    }

    protected void setupRotations(Rotbeast entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (!((double)entity.walkAnimation.speed() < 0.01)) {
            float f1 = entity.walkAnimation.position() - entity.walkAnimation.speed() * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            stack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }
}

