/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class UtheriumCritParticle
extends TextureSheetParticle {
    private float rotSpeed;
    private final float spinAcceleration;

    protected UtheriumCritParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 1.0f;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += xSpeed * 0.05;
        this.yd += ySpeed * 0.1;
        this.zd += zSpeed * 0.05;
        this.quadSize *= 0.75f;
        this.hasPhysics = true;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -90.0 : 90.0);
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -15.0 : 15.0);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround) {
                this.remove();
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            UtheriumCritParticle crit = new UtheriumCritParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            crit.lifetime = 40;
            crit.gravity = 0.025f;
            crit.pickSprite(this.spriteSet);
            return crit;
        }
    }
}

