/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class ShardParticle
extends RisingParticle {
    private ShardParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(level, x, y, z, motionX, motionY, motionZ);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    public float getQuadSize(float scaleFactor) {
        float lvt_2_1_ = ((float)this.age + scaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - lvt_2_1_ * lvt_2_1_ * 0.5f);
    }

    public int getLightColor(float partialTicks) {
        float lvt_2_1_ = ((float)this.age + partialTicks) / (float)this.lifetime;
        lvt_2_1_ = Mth.clamp((float)lvt_2_1_, (float)0.0f, (float)1.0f);
        int lightColor = super.getLightColor(partialTicks);
        int lvt_4_1_ = lightColor & 0xFF;
        int lvt_5_1_ = lightColor >> 16 & 0xFF;
        if ((lvt_4_1_ += (int)(lvt_2_1_ * 15.0f * 16.0f)) > 240) {
            lvt_4_1_ = 240;
        }
        return lvt_4_1_ | lvt_5_1_ << 16;
    }

    public static class BeamProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BeamProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ShardParticle shard = new ShardParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            shard.lifetime = 5;
            shard.pickSprite(this.spriteSet);
            return shard;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ShardParticle shard = new ShardParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            shard.pickSprite(this.spriteSet);
            return shard;
        }
    }
}

