/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.MysteriousPot;

public class MysteriousPotModel
extends HierarchicalModel<MysteriousPot> {
    private final ModelPart root;
    private final ModelPart front_right_leg;
    private final ModelPart front_left_leg;
    private final ModelPart back_right_leg;
    private final ModelPart back_left_leg;

    public MysteriousPotModel(ModelPart root) {
        this.root = root;
        this.front_right_leg = root.getChild("front_right_leg");
        this.front_left_leg = root.getChild("front_left_leg");
        this.back_right_leg = root.getChild("back_right_leg");
        this.back_left_leg = root.getChild("back_left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("pot", CubeListBuilder.create().texOffs(32, 29).addBox(-8.0f, -16.0f, 0.0f, 8.0f, 3.0f, 8.0f).texOffs(0, 23).addBox(-9.0f, -2.0f, -1.0f, 10.0f, 4.0f, 10.0f).texOffs(0, 0).addBox(-10.0f, -13.0f, -2.0f, 12.0f, 11.0f, 12.0f).texOffs(0, 42).addBox(-6.0f, -3.0f, -2.0f, 4.0f, 1.0f, 1.0f), PartPose.offset((float)4.0f, (float)19.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("front_right_leg", CubeListBuilder.create().texOffs(30, 23).addBox(-1.0f, 0.0f, -0.25f, 2.0f, 3.0f, 3.0f).texOffs(8, 37).addBox(-1.0f, 3.0f, -0.25f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)-5.0f, (float)18.0f, (float)-4.75f, (float)-0.1745f, (float)-2.3562f, (float)0.0f));
        partdefinition.addOrReplaceChild("front_left_leg", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, 0.0f, -0.25f, 2.0f, 3.0f, 3.0f).mirror(false).texOffs(8, 37).mirror().addBox(-1.0f, 3.0f, -0.25f, 2.0f, 3.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)18.0f, (float)-4.75f, (float)-0.1745f, (float)2.3562f, (float)0.0f));
        partdefinition.addOrReplaceChild("back_right_leg", CubeListBuilder.create().texOffs(0, 6).addBox(-1.0f, 0.0f, -2.75f, 2.0f, 3.0f, 3.0f).texOffs(36, 5).addBox(-1.0f, 3.0f, -1.75f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)-5.0f, (float)18.0f, (float)4.75f, (float)0.1745f, (float)2.3562f, (float)0.0f));
        partdefinition.addOrReplaceChild("back_left_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -2.75f, 2.0f, 3.0f, 3.0f).mirror(false).texOffs(36, 0).mirror().addBox(-1.0f, 3.0f, -1.75f, 2.0f, 3.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)18.0f, (float)4.75f, (float)0.1745f, (float)-2.3562f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(MysteriousPot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.front_right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / 3.0f;
        this.front_left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / 3.0f;
        this.back_right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / 3.0f;
        this.back_left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / 3.0f;
    }
}

