/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import quek.undergarden.registry.UGBlocks;

public class SpreadingDeepturfBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public static final MapCodec<SpreadingDeepturfBlock> CODEC = SpreadingDeepturfBlock.simpleCodec(SpreadingDeepturfBlock::new);

    public SpreadingDeepturfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends SpreadingSnowyDirtBlock> codec() {
        return CODEC;
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return SpreadingDeepturfBlock.canBeGrass((BlockState)state, (LevelReader)level, (BlockPos)pos) && !level.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!SpreadingDeepturfBlock.canBeGrass((BlockState)state, (LevelReader)level, (BlockPos)pos)) {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            level.setBlockAndUpdate(pos, ((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState());
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            BlockState blockstate = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!level.getBlockState(blockpos).is((Block)UGBlocks.DEEPSOIL.get()) || !SpreadingDeepturfBlock.canPropagate(blockstate, (LevelReader)level, blockpos)) continue;
                level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockpos.above()).is(Blocks.SNOW))));
            }
        }
    }

    public boolean onTreeGrow(BlockState state, LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        placeFunction.accept(pos, ((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState());
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.above();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockpos1 = blockpos1.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)level, blockpos1)) continue block0;
            }
            BlockState blockstate2 = level.getBlockState(blockpos1);
            if (blockstate2.is(SpreadingDeepturfBlock.deepturfOrShimmerweed(random).getBlock()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)SpreadingDeepturfBlock.deepturfOrShimmerweed(random).getBlock()).performBonemeal(level, random, blockpos1, blockstate2);
            }
            if (!blockstate2.isAir() || !SpreadingDeepturfBlock.deepturfOrShimmerweed(random).canSurvive((LevelReader)level, blockpos1)) continue;
            level.setBlock(blockpos1, SpreadingDeepturfBlock.deepturfOrShimmerweed(random), 3);
        }
    }

    private static BlockState deepturfOrShimmerweed(RandomSource random) {
        if (random.nextInt(10) == 0) {
            return ((Block)UGBlocks.SHIMMERWEED.get()).defaultBlockState();
        }
        return ((Block)UGBlocks.DEEPTURF.get()).defaultBlockState();
    }
}

