/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGParticleTypes;

public class SeepingInkBlock
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public SeepingInkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)accessor, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.above()).isFaceSturdy((BlockGetter)reader, pos.above(), Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getRandom().nextInt(level.getBlockState(pos.above()).is((Block)UGBlocks.INK_MUSHROOM_CAP.get()) ? 5 : 15) == 0 && level.getBlockState(pos.below()).isAir()) {
            level.addParticle((ParticleOptions)UGParticleTypes.DRIPPING_INK.get(), (double)pos.getX() + 0.55, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.45, 0.0, 0.0, 0.0);
        }
    }
}

