/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import com.mojang.logging.LogUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.client.UndergardenClient;
import quek.undergarden.event.UndergardenClientEvents;
import quek.undergarden.event.UndergardenCommonEvents;
import quek.undergarden.registry.UGArmorMaterials;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGCreativeModeTabs;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDataComponents;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGFoliagePlacers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGMenuTypes;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGRecipeSerializers;
import quek.undergarden.registry.UGRecipeTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGTreeDecoratorTypes;
import quek.undergarden.registry.UGTrunkPlacerTypes;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Undergarden(IEventBus bus, Dist dist, ModContainer container) {
        DeferredRegister[] registers;
        NeoForgeMod.enableMilkFluid();
        if (dist.isClient()) {
            UndergardenClientEvents.initClientEvents(bus);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        UndergardenCommonEvents.initCommonEvents(bus);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGAttachments.ATTACHMENTS, UGBlockEntities.BLOCK_ENTITIES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGCreativeModeTabs.TABS, UGCriteria.CRITERIA, UGEffects.EFFECTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGFluids.TYPES, UGFoliagePlacers.FOLIAGE_PLACERS, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructures.STRUCTURES, UGTreeDecoratorTypes.TREE_DECORATORS, UGTrunkPlacerTypes.TRUNK_PLACERS, UGArmorMaterials.ARMOR_MATERIALS, UGMenuTypes.MENU_TYPES, UGRecipeSerializers.RECIPE_SERIALIZERS, UGRecipeTypes.RECIPE_TYPES, UGDataComponents.COMPONENTS}) {
            register.register(bus);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UndergardenConfig.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)UndergardenConfig.CLIENT_SPEC);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    @Nullable
    public static RegistryAccess registryAccessStatic() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            return currentServer.registryAccess();
        }
        return UndergardenClient.registryAccess();
    }
}

