/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders;

import com.mrcrayfish.framework.api.config.BoolProperty;
import com.mrcrayfish.framework.api.config.ConfigProperty;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.FrameworkConfig;
import com.mrcrayfish.framework.api.config.IntProperty;
import com.mrcrayfish.goblintraders.spawner.IGoblinData;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeRarity;

public final class Config {
    @FrameworkConfig(id="goblintraders", name="entities", separator=45)
    public static final Entities ENTITIES = new Entities();

    public static class Entities {
        @ConfigProperty(name="goblinTrader")
        public final Goblin goblinTrader;
        @ConfigProperty(name="veinGoblinTrader")
        public final Goblin veinGoblinTrader;
        @ConfigProperty(name="preventDespawnIfNamed", comment="If true, prevents the trader from despawning if named")
        public final BoolProperty preventDespawnIfNamed = BoolProperty.create((boolean)true);

        private Entities() {
            this.goblinTrader = new Goblin(25, 12000, 24000, 24000, -64, 50);
            this.veinGoblinTrader = new Goblin(25, 12000, 24000, 24000, 0, 128);
        }

        public static class Goblin
        implements IGoblinData {
            @ConfigProperty(name="traderSpawnChance", comment="The chance out of one hundred that the trader will spawn in the over world")
            public final IntProperty spawnChance;
            @ConfigProperty(name="spawnInterval", comment="The amount of ticks to wait before trying to spawn a trader again if the spawn failed")
            public final IntProperty spawnInterval;
            @ConfigProperty(name="traderSpawnDelay", comment="The amount of ticks before the trader will start spawning in a new world")
            public final IntProperty spawnDelay;
            @ConfigProperty(name="traderDespawnDelay", comment="The amount of ticks before the trader will despawn")
            public final IntProperty despawnDelay;
            @ConfigProperty(name="traderMinSpawnLevel", comment="The minimum level the trader can spawn", worldRestart=true)
            public final IntProperty minSpawnYLevel;
            @ConfigProperty(name="traderMaxSpawnLevel", comment="The maximum level the trader can spawn", worldRestart=true)
            public final IntProperty maxSpawnYLevel;
            @ConfigProperty(name="restockDelay", comment="The amount of ticks before the trader will replenish it's trades. Set to -1 to disable restocking")
            public final IntProperty restockDelay;
            @ConfigProperty(name="canAttackBack", comment="If true, the goblin will try to hit back a player or mob that hit them")
            public final BoolProperty canAttackBack;
            @ConfigProperty(name="gruntNoiseInterval", comment="Goblins will make a grunt noise while walking around. If you find it happening too often, you can increase the interval. Value is represented in ticks.")
            public final IntProperty gruntNoiseInterval;
            @ConfigProperty(name="trades")
            public final Trades trades = new Trades();

            private Goblin(int spawnChance, int spawnInterval, int spawnDelay, int despawnDelay, int minLevel, int maxLevel) {
                this.spawnChance = IntProperty.create((int)spawnChance, (int)1, (int)100);
                this.spawnInterval = IntProperty.create((int)spawnInterval, (int)1, (int)Integer.MAX_VALUE);
                this.spawnDelay = IntProperty.create((int)spawnDelay, (int)1, (int)Integer.MAX_VALUE);
                this.despawnDelay = IntProperty.create((int)despawnDelay, (int)1, (int)Integer.MAX_VALUE);
                this.minSpawnYLevel = IntProperty.create((int)minLevel, (int)-64, (int)320);
                this.maxSpawnYLevel = IntProperty.create((int)maxLevel, (int)-64, (int)320);
                this.restockDelay = IntProperty.create((int)48000, (int)-1, (int)Integer.MAX_VALUE);
                this.canAttackBack = BoolProperty.create((boolean)true);
                this.gruntNoiseInterval = IntProperty.create((int)80, (int)1, (int)1000);
            }

            @Override
            public int getSpawnChance() {
                return (Integer)this.spawnChance.get();
            }

            @Override
            public int getSpawnInterval() {
                return (Integer)this.spawnInterval.get();
            }

            @Override
            public int getDespawnDelay() {
                return (Integer)this.despawnDelay.get();
            }

            @Override
            public int getSpawnDelay() {
                return (Integer)this.spawnDelay.get();
            }

            @Override
            public int getMinSpawnYLevel() {
                return (Integer)this.minSpawnYLevel.get();
            }

            @Override
            public int getMaxSpawnYLevel() {
                return (Integer)this.maxSpawnYLevel.get();
            }

            @Override
            public int getRestockDelay() {
                return (Integer)this.restockDelay.get();
            }

            @Override
            public boolean canAttackBack() {
                return (Boolean)this.canAttackBack.get();
            }

            @Override
            public int getGruntNoiseInterval() {
                return (Integer)this.gruntNoiseInterval.get();
            }

            public static class Trades {
                @ConfigProperty(name="common")
                public final Trade common = new Trade(5, 8, 1.0);
                @ConfigProperty(name="uncommon")
                public final Trade uncommon = new Trade(3, 5, 1.0);
                @ConfigProperty(name="rare")
                public final Trade rare = new Trade(2, 3, 1.0);
                @ConfigProperty(name="epic")
                public final Trade epic = new Trade(1, 2, 1.0);
                @ConfigProperty(name="legendary")
                public final Trade legendary = new Trade(1, 1, 0.75);

                public IRaritySettings getSettings(TradeRarity rarity) {
                    return switch (rarity) {
                        default -> throw new MatchException(null, null);
                        case TradeRarity.COMMON -> this.common;
                        case TradeRarity.UNCOMMON -> this.uncommon;
                        case TradeRarity.RARE -> this.rare;
                        case TradeRarity.EPIC -> this.epic;
                        case TradeRarity.LEGENDARY -> this.legendary;
                    };
                }

                public static class Trade
                implements IRaritySettings {
                    @ConfigProperty(name="minAmount", comment="The minimum amount of trades that a golbin will have.")
                    public final IntProperty minAmount;
                    @ConfigProperty(name="manAmount", comment="The maximum amount of trades that a golbin can have.")
                    public final IntProperty maxAmount;
                    @ConfigProperty(name="includeChance", comment="The chance this trade rarity will be included in the goblin's trades")
                    public final DoubleProperty includeChance;

                    public Trade(int min, int max, double includeChance) {
                        this.minAmount = IntProperty.create((int)min, (int)0, (int)Integer.MAX_VALUE);
                        this.maxAmount = IntProperty.create((int)max, (int)0, (int)Integer.MAX_VALUE);
                        this.includeChance = DoubleProperty.create((double)includeChance, (double)0.0, (double)1.0);
                    }

                    @Override
                    public int getMinValue() {
                        return (Integer)this.minAmount.get();
                    }

                    @Override
                    public int getMaxValue() {
                        return (Integer)this.maxAmount.get();
                    }

                    @Override
                    public double includeChance() {
                        return (Double)this.includeChance.get();
                    }
                }
            }
        }
    }
}

