/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.screen.custom;

import com.blocklogic.agritechevolved.compat.jei.ATEJeiPlugin;
import com.blocklogic.agritechevolved.compat.jei.PlanterRecipeCategory;
import com.blocklogic.agritechevolved.screen.custom.BasicPlanterMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BasicPlanterScreen
extends AbstractContainerScreen<BasicPlanterMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"textures/gui/basic_planter_gui.png");

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY -= 2;
    }

    public BasicPlanterScreen(BasicPlanterMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        float growthProgress = ((BasicPlanterMenu)this.menu).blockEntity.getGrowthProgress();
        if (growthProgress > 0.0f) {
            int progressBarHeight = (int)(52.0f * growthProgress);
            int progressBarY = y + 16 + 52 - progressBarHeight;
            guiGraphics.blit(GUI_TEXTURE, x + 58, progressBarY, 176, 52 - progressBarHeight, 6, progressBarHeight);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        if (x >= guiX + 58 && x <= guiX + 58 + 6 && y >= guiY + 16 && y <= guiY + 16 + 53) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            float progress = ((BasicPlanterMenu)this.menu).blockEntity.getGrowthProgress();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.growth_progress"));
            tooltip.add(Component.literal((String)String.format("%.1f%%", Float.valueOf(progress * 100.0f))).withStyle(ChatFormatting.GREEN));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.view_recipes").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.renderComponentTooltip(this.font, tooltip, x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiX = (this.width - this.imageWidth) / 2;
            int guiY = (this.height - this.imageHeight) / 2;
            if (mouseX >= (double)(guiX + 58) && mouseX <= (double)(guiX + 58 + 6) && mouseY >= (double)(guiY + 16) && mouseY <= (double)(guiY + 16 + 53)) {
                IJeiRuntime runtime;
                if (this.minecraft != null && this.minecraft.player != null && (runtime = ATEJeiPlugin.getJeiRuntime()) != null) {
                    runtime.getRecipesGui().showTypes(List.of(PlanterRecipeCategory.PLANTER_RECIPE_TYPE));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

