/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.recipe;

import com.blocklogic.agritechevolved.recipe.ATERecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class DurabilityShapelessRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient toolIngredient;
    private final int durabilityPerItem;

    public DurabilityShapelessRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, Ingredient toolIngredient, int durabilityPerItem) {
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.toolIngredient = toolIngredient;
        this.durabilityPerItem = durabilityPerItem;
    }

    public boolean matches(CraftingInput input, Level level) {
        NonNullList requiredIngredients = NonNullList.create();
        requiredIngredients.addAll(this.ingredients);
        boolean foundTool = false;
        int totalProcessableItems = 0;
        ItemStack foundToolStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack inputStack = input.getItem(i);
            if (inputStack.isEmpty()) continue;
            if (this.toolIngredient.test(inputStack)) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                foundToolStack = inputStack;
                continue;
            }
            boolean matchedIngredient = false;
            for (int j = 0; j < requiredIngredients.size(); ++j) {
                if (!((Ingredient)requiredIngredients.get(j)).test(inputStack)) continue;
                ++totalProcessableItems;
                requiredIngredients.remove(j);
                matchedIngredient = true;
                break;
            }
            if (matchedIngredient) continue;
            return false;
        }
        if (!foundTool || !requiredIngredients.isEmpty()) {
            return false;
        }
        if (foundToolStack.isDamageableItem()) {
            int maxDurability;
            int neededDurability;
            int currentDamage = foundToolStack.getDamageValue();
            return currentDamage + (neededDurability = totalProcessableItems * this.durabilityPerItem) < (maxDurability = foundToolStack.getMaxDamage());
        }
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int processableItems = 0;
        block0: for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || this.toolIngredient.test(stack)) continue;
            for (Ingredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                ++processableItems;
                continue block0;
            }
        }
        ItemStack result = this.result.copy();
        result.setCount(processableItems);
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size() + 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remaining = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        ItemStack toolStack = ItemStack.EMPTY;
        int toolSlot = -1;
        int processableItems = 0;
        block0: for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.toolIngredient.test(stack)) {
                toolStack = stack.copy();
                toolSlot = i;
                continue;
            }
            for (Ingredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                ++processableItems;
                continue block0;
            }
        }
        if (!toolStack.isEmpty() && toolSlot != -1) {
            int totalDurabilityNeeded = processableItems * this.durabilityPerItem;
            if (toolStack.isDamageableItem()) {
                int maxDurability;
                int currentDamage = toolStack.getDamageValue();
                int newDamage = currentDamage + totalDurabilityNeeded;
                if (newDamage >= (maxDurability = toolStack.getMaxDamage())) {
                    remaining.set(toolSlot, (Object)ItemStack.EMPTY);
                } else {
                    toolStack.setDamageValue(newDamage);
                    remaining.set(toolSlot, (Object)toolStack);
                }
            } else {
                remaining.set(toolSlot, (Object)toolStack);
            }
        }
        return remaining;
    }

    public RecipeSerializer<?> getSerializer() {
        return ATERecipes.DURABILITY_SHAPELESS_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public Ingredient getToolIngredient() {
        return this.toolIngredient;
    }

    public int getDurabilityPerItem() {
        return this.durabilityPerItem;
    }
}

