/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.compat.jei;

import com.blocklogic.agritechevolved.block.ATEBlocks;
import com.blocklogic.agritechevolved.compat.jei.CompostRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"composting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"textures/gui/jei/jei_composter_gui.png");
    public static final RecipeType<CompostRecipe> COMPOST_RECIPE_TYPE = new RecipeType(UID, CompostRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public CompostRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 134, 72);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ATEBlocks.COMPOSTER.get()));
    }

    public RecipeType<CompostRecipe> getRecipeType() {
        return COMPOST_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.agritechevolved.composting.tooltip");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 134;
    }

    public int getHeight() {
        return 72;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompostRecipe recipe, IFocusGroup focuses) {
        ItemStack[] inputItems = recipe.getInput().getItems();
        if (inputItems.length > 0) {
            ItemStack displayStack = inputItems[0].copy();
            displayStack.setCount(32);
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).addItemStack(displayStack);
        }
        int outputIndex = 0;
        for (ItemStack output : recipe.getOutputs()) {
            int x = 106;
            int y = 10 + outputIndex * 18;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(output);
            ++outputIndex;
        }
    }

    public void draw(CompostRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }
}

