/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.compat.jei;

import com.blocklogic.agritechevolved.block.ATEBlocks;
import com.blocklogic.agritechevolved.compat.jei.CompostRecipe;
import com.blocklogic.agritechevolved.compat.jei.CompostRecipeCategory;
import com.blocklogic.agritechevolved.compat.jei.PlanterRecipe;
import com.blocklogic.agritechevolved.compat.jei.PlanterRecipeCategory;
import com.blocklogic.agritechevolved.config.CompostableConfig;
import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class ATEJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"jei_plugin");
    private static IJeiRuntime jeiRuntime;

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PlanterRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new CompostRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<PlanterRecipe> planterRecipes = this.generatePlanterRecipes();
        registration.addRecipes(PlanterRecipeCategory.PLANTER_RECIPE_TYPE, planterRecipes);
        List<CompostRecipe> compostRecipes = this.generateCompostRecipes();
        registration.addRecipes(CompostRecipeCategory.COMPOST_RECIPE_TYPE, compostRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ATEBlocks.ADVANCED_PLANTER.get()), new RecipeType[]{PlanterRecipeCategory.PLANTER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ATEBlocks.COMPOSTER.get()), new RecipeType[]{CompostRecipeCategory.COMPOST_RECIPE_TYPE});
    }

    private List<PlanterRecipe> generatePlanterRecipes() {
        ArrayList<PlanterRecipe> recipes = new ArrayList<PlanterRecipe>();
        recipes.addAll(this.generateCropRecipes());
        recipes.addAll(this.generateTreeRecipes());
        LogUtils.getLogger().info("Generated {} total planter recipes for JEI", (Object)recipes.size());
        return recipes;
    }

    private List<CompostRecipe> generateCompostRecipes() {
        ArrayList<CompostRecipe> recipes = new ArrayList<CompostRecipe>();
        for (String itemId : CompostableConfig.getCompostableItems()) {
            try {
                CompostRecipe recipe = CompostRecipe.create(itemId);
                if (recipe == null || recipe.getOutputs().isEmpty()) continue;
                recipes.add(recipe);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Error creating compost recipe for item {}: {}", new Object[]{itemId, e.getMessage(), e});
            }
        }
        LogUtils.getLogger().info("Generated {} compost recipes for JEI", (Object)recipes.size());
        return recipes;
    }

    private List<PlanterRecipe> generateCropRecipes() {
        ArrayList<PlanterRecipe> recipes = new ArrayList<PlanterRecipe>();
        Map<String, List<String>> seedToSoilMap = PlantablesConfig.getAllSeedToSoilMappings();
        for (Map.Entry<String, List<String>> entry : seedToSoilMap.entrySet()) {
            String seedId = entry.getKey();
            for (String soilId : entry.getValue()) {
                try {
                    Block soilBlock = RegistryHelper.getBlock(soilId);
                    if (soilBlock == null) {
                        LogUtils.getLogger().error("Invalid soil block in config: {} for seed {}", (Object)soilId, (Object)seedId);
                        continue;
                    }
                    PlanterRecipe recipe = PlanterRecipe.createCrop(seedId, soilId);
                    if (recipe == null || recipe.getOutputs().isEmpty()) continue;
                    recipes.add(recipe);
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("Error creating recipe for seed {} and soil {}: {}", new Object[]{seedId, soilId, e.getMessage(), e});
                }
            }
        }
        LogUtils.getLogger().info("Generated {} crop planter recipes for JEI", (Object)recipes.size());
        return recipes;
    }

    private List<PlanterRecipe> generateTreeRecipes() {
        ArrayList<PlanterRecipe> recipes = new ArrayList<PlanterRecipe>();
        Map<String, List<String>> saplingToSoilMap = PlantablesConfig.getAllSaplingToSoilMappings();
        for (Map.Entry<String, List<String>> entry : saplingToSoilMap.entrySet()) {
            String saplingId = entry.getKey();
            for (String soilId : entry.getValue()) {
                try {
                    Block soilBlock = RegistryHelper.getBlock(soilId);
                    if (soilBlock == null) {
                        LogUtils.getLogger().error("Invalid soil block in config: {} for sapling {}", (Object)soilId, (Object)saplingId);
                        continue;
                    }
                    PlanterRecipe recipe = PlanterRecipe.createTree(saplingId, soilId);
                    if (recipe == null || recipe.getOutputs().isEmpty()) continue;
                    recipes.add(recipe);
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("Error creating recipe for sapling {} and soil {}: {}", new Object[]{saplingId, soilId, e.getMessage(), e});
                }
            }
        }
        LogUtils.getLogger().info("Generated {} tree planter recipes for JEI", (Object)recipes.size());
        return recipes;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ATEJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public static IJeiRuntime getJeiRuntime() {
        return jeiRuntime;
    }
}

