/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity;

import com.blocklogic.agritechevolved.Config;
import com.blocklogic.agritechevolved.block.ATEBlocks;
import com.blocklogic.agritechevolved.block.custom.CapacitorTier1Block;
import com.blocklogic.agritechevolved.block.custom.CapacitorTier2Block;
import com.blocklogic.agritechevolved.block.custom.CapacitorTier3Block;
import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.screen.custom.CapacitorMenu;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class CapacitorBlockEntity
extends BlockEntity
implements MenuProvider {
    private EnergyStorage energyStorage;
    private int tier = 1;
    private int transferRate = 512;

    public CapacitorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ATEBlockEntities.CAPACITOR_BE.get(), pos, blockState);
        this.initializeCapacitor(blockState);
    }

    private void initializeCapacitor(BlockState blockState) {
        if (blockState.is((Block)ATEBlocks.CAPACITOR_TIER1.get())) {
            this.tier = 1;
            this.transferRate = Config.getCapacitorT1TransferRate();
            this.energyStorage = new EnergyStorage(Config.getCapacitorT1Buffer()){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    int received = super.receiveEnergy(Math.min(maxReceive, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && received > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return received;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    int extracted = super.extractEnergy(Math.min(maxExtract, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && extracted > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return extracted;
                }
            };
        } else if (blockState.is((Block)ATEBlocks.CAPACITOR_TIER2.get())) {
            this.tier = 2;
            this.transferRate = Config.getCapacitorT2TransferRate();
            this.energyStorage = new EnergyStorage(Config.getCapacitorT2Buffer()){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    int received = super.receiveEnergy(Math.min(maxReceive, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && received > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return received;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    int extracted = super.extractEnergy(Math.min(maxExtract, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && extracted > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return extracted;
                }
            };
        } else if (blockState.is((Block)ATEBlocks.CAPACITOR_TIER3.get())) {
            this.tier = 3;
            this.transferRate = Config.getCapacitorT3TransferRate();
            this.energyStorage = new EnergyStorage(Config.getCapacitorT3Buffer()){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    int received = super.receiveEnergy(Math.min(maxReceive, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && received > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return received;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    int extracted = super.extractEnergy(Math.min(maxExtract, CapacitorBlockEntity.this.transferRate), simulate);
                    if (!simulate && extracted > 0) {
                        CapacitorBlockEntity.this.setChanged();
                        if (!CapacitorBlockEntity.this.level.isClientSide()) {
                            CapacitorBlockEntity.this.level.sendBlockUpdated(CapacitorBlockEntity.this.getBlockPos(), CapacitorBlockEntity.this.getBlockState(), CapacitorBlockEntity.this.getBlockState(), 3);
                        }
                    }
                    return extracted;
                }
            };
        } else {
            this.tier = 1;
            this.transferRate = Config.getCapacitorT1TransferRate();
            this.energyStorage = new EnergyStorage(Config.getCapacitorT1Buffer());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CapacitorBlockEntity blockEntity) {
        boolean currentlyHasEnergy;
        boolean hasEnergy;
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean wasChanged = false;
        for (Direction direction : Direction.values()) {
            int transferred;
            int energyToTransfer;
            IEnergyStorage neighborEnergy;
            if (direction == Direction.DOWN) continue;
            if (blockEntity.energyStorage.getEnergyStored() <= 0) break;
            BlockPos neighborPos = pos.relative(direction);
            BlockEntity neighborBE = level.getBlockEntity(neighborPos);
            if (neighborBE == null || (neighborEnergy = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite())) == null || !neighborEnergy.canReceive() || (energyToTransfer = blockEntity.energyStorage.extractEnergy(blockEntity.transferRate, true)) <= 0 || (transferred = neighborEnergy.receiveEnergy(energyToTransfer, false)) <= 0) continue;
            blockEntity.energyStorage.extractEnergy(transferred, false);
            wasChanged = true;
        }
        if (wasChanged) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
        }
        boolean bl = hasEnergy = blockEntity.getEnergyStored() > 0;
        if (state.is((Block)ATEBlocks.CAPACITOR_TIER1.get())) {
            currentlyHasEnergy = (Boolean)state.getValue((Property)CapacitorTier1Block.HAS_ENERGY);
            if (hasEnergy != currentlyHasEnergy) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CapacitorTier1Block.HAS_ENERGY, (Comparable)Boolean.valueOf(hasEnergy)), 3);
            }
        } else if (state.is((Block)ATEBlocks.CAPACITOR_TIER2.get())) {
            currentlyHasEnergy = (Boolean)state.getValue((Property)CapacitorTier2Block.HAS_ENERGY);
            if (hasEnergy != currentlyHasEnergy) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CapacitorTier2Block.HAS_ENERGY, (Comparable)Boolean.valueOf(hasEnergy)), 3);
            }
        } else if (state.is((Block)ATEBlocks.CAPACITOR_TIER3.get()) && hasEnergy != (currentlyHasEnergy = ((Boolean)state.getValue((Property)CapacitorTier3Block.HAS_ENERGY)).booleanValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CapacitorTier3Block.HAS_ENERGY, (Comparable)Boolean.valueOf(hasEnergy)), 3);
        }
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getTier() {
        return this.tier;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public String getTierName() {
        return switch (this.tier) {
            case 1 -> "Tier 1";
            case 2 -> "Tier 2";
            case 3 -> "Tier 3";
            default -> "Unknown";
        };
    }

    public void forceSetEnergy(int energy) {
        if (this.energyStorage != null) {
            int maxEnergy = this.energyStorage.getMaxEnergyStored();
            int clampedEnergy = Math.min(energy, maxEnergy);
            EnergyStorage energyStorage = this.energyStorage;
            if (energyStorage instanceof EnergyStorage) {
                EnergyStorage storage = energyStorage;
                try {
                    Field energyField = EnergyStorage.class.getDeclaredField("energy");
                    energyField.setAccessible(true);
                    energyField.setInt(storage, clampedEnergy);
                }
                catch (Exception e) {
                    while (this.energyStorage.getEnergyStored() < clampedEnergy && this.energyStorage.receiveEnergy(clampedEnergy - this.energyStorage.getEnergyStored(), false) > 0) {
                    }
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.energyStorage != null) {
            tag.put("energy", this.energyStorage.serializeNBT(registries));
        }
        tag.putInt("tier", this.tier);
        tag.putInt("transferRate", this.transferRate);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.getBlockState() != null) {
            this.initializeCapacitor(this.getBlockState());
        }
        if (tag.contains("energy") && this.energyStorage != null) {
            this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        }
        if (tag.contains("tier")) {
            this.tier = tag.getInt("tier");
        }
        if (tag.contains("transferRate")) {
            this.transferRate = tag.getInt("transferRate");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getEnergyStored() {
        return this.energyStorage != null ? this.energyStorage.getEnergyStored() : 0;
    }

    public int getMaxEnergyStored() {
        return this.energyStorage != null ? this.energyStorage.getMaxEnergyStored() : 0;
    }

    public boolean canExtractEnergy() {
        return true;
    }

    public boolean canReceiveEnergy() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage != null ? this.energyStorage.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage != null ? this.energyStorage.extractEnergy(maxExtract, simulate) : 0;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        if (side == Direction.DOWN) {
            return null;
        }
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return CapacitorBlockEntity.this.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return CapacitorBlockEntity.this.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return CapacitorBlockEntity.this.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return CapacitorBlockEntity.this.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return CapacitorBlockEntity.this.canExtractEnergy();
            }

            public boolean canReceive() {
                return CapacitorBlockEntity.this.canReceiveEnergy();
            }
        };
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ATEBlockEntities.CAPACITOR_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof CapacitorBlockEntity) {
                CapacitorBlockEntity capacitorBlockEntity = blockEntity;
                return capacitorBlockEntity.getEnergyStorage((Direction)direction);
            }
            return null;
        });
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)("gui.agritechevolved.capacitor_tier" + this.tier));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CapacitorMenu(containerId, playerInventory, this);
    }
}

