/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.custom;

import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.block.entity.CapacitorBlockEntity;
import com.blocklogic.agritechevolved.component.ATEDataComponents;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CapacitorTier1Block
extends BaseEntityBlock {
    public static final MapCodec<CapacitorTier1Block> CODEC = CapacitorTier1Block.simpleCodec(CapacitorTier1Block::new);
    public static final BooleanProperty HAS_ENERGY = BooleanProperty.create((String)"has_energy");

    public CapacitorTier1Block(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_ENERGY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_ENERGY});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CapacitorBlockEntity(blockPos, blockState);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CapacitorBlockEntity) {
            CapacitorBlockEntity capacitorBlockEntity = (CapacitorBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)capacitorBlockEntity, (Component)Component.translatable((String)"gui.agritechevolved.capacitor")), pos);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof CapacitorBlockEntity) {
            CapacitorBlockEntity capacitorBlockEntity = (CapacitorBlockEntity)blockEntity;
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof CapacitorBlockEntity) {
            CapacitorBlockEntity capacitorBlockEntity = (CapacitorBlockEntity)blockEntity;
            if (!drops.isEmpty()) {
                ItemStack drop = (ItemStack)drops.get(0);
                int storedEnergy = capacitorBlockEntity.getEnergyStored();
                if (storedEnergy > 0) {
                    drop.set((DataComponentType)ATEDataComponents.STORED_ENERGY.get(), (Object)storedEnergy);
                    drop.set((DataComponentType)ATEDataComponents.CAPACITOR_TIER.get(), (Object)capacitorBlockEntity.getTier());
                }
            }
        }
        return drops;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        Integer storedEnergy = (Integer)stack.get((DataComponentType)ATEDataComponents.STORED_ENERGY.get());
        if (storedEnergy != null && storedEnergy > 0 && (blockEntity = level.getBlockEntity(pos)) instanceof CapacitorBlockEntity) {
            CapacitorBlockEntity capacitorBlockEntity = (CapacitorBlockEntity)blockEntity;
            capacitorBlockEntity.forceSetEnergy(storedEnergy);
            capacitorBlockEntity.setChanged();
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ATEBlockEntities.CAPACITOR_BE.get() ? (lvl, pos, blockState, blockEntity) -> CapacitorBlockEntity.tick(lvl, pos, blockState, (CapacitorBlockEntity)blockEntity) : null;
    }
}

