/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import net.minecraft.world.phys.Vec3;

public class WireSlackHelper {
    public static Vec3[] getInterpolatedDifferences(Vec3 vector) {
        int points = 17;
        Vec3[] list = new Vec3[points];
        double dx = vector.x();
        double dy = vector.y();
        double dz = vector.z();
        double sag = 0.3;
        for (int point = 0; point < points; ++point) {
            double startLerp = WireSlackHelper.getFractionalLerp(point, points - 1);
            double startYLerp = WireSlackHelper.getYLerp(startLerp, dy);
            double sagFactor = sag * (1.0 - 4.0 * Math.pow(startLerp - 0.5, 2.0));
            double y = dy != 0.0 ? (startYLerp - sagFactor) * dy : -sagFactor;
            list[point] = new Vec3(startLerp * dx, y, startLerp * dz);
        }
        return list;
    }

    public static Vec3[] getInterpolatedPoints(Vec3 a, Vec3 b) {
        Vec3 diff = b.subtract(a);
        Vec3[] diffs = WireSlackHelper.getInterpolatedDifferences(diff);
        Vec3[] points = new Vec3[diffs.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = a.add(diffs[i]);
        }
        return points;
    }

    public static double getFractionalLerp(int current, int max) {
        return (double)current / (double)max;
    }

    public static double getYLerp(double lerp, double dY) {
        return Math.pow(lerp, Math.log(Math.abs(dY) + 3.0));
    }
}

