/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record Wire(BlockPos from, BlockPos to) {
    public static final Codec<Wire> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("from").forGetter(Wire::from), (App)BlockPos.CODEC.fieldOf("to").forGetter(Wire::to)).apply((Applicative)instance, Wire::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Wire> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, w -> w.from, (StreamCodec)BlockPos.STREAM_CODEC, w -> w.to, Wire::new);

    public Wire(BlockPos from, BlockPos to) {
        this.from = from.immutable();
        this.to = to.immutable();
    }

    public static Wire load(CompoundTag tag) {
        return new Wire(BlockPos.of((long)tag.getLong("from")), BlockPos.of((long)tag.getLong("to")));
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putLong("from", this.from.asLong());
        tag.putLong("to", this.to.asLong());
        return tag;
    }
}

