/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.CalcinationRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CalcinationCategory
implements IRecipeCategory<RecipeHolder<CalcinationRecipe>> {
    private final IDrawableAnimated animatedFire;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public CalcinationCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(82, 43);
        this.animatedFire = JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_FIRE_FULL, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.CALCINATION_OVEN.get()));
        this.localizedName = Component.translatable((String)"theurgy.jei.category.calcination");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getAnimatedArrow(RecipeHolder<CalcinationRecipe> recipe) {
        int cookTime = ((CalcinationRecipe)recipe.value()).getTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull RecipeHolder<CalcinationRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_FIRE_EMPTY.render(guiGraphics, 1, 20);
        this.animatedFire.draw(guiGraphics, 1, 20);
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 24, 8);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 24, 8);
        this.drawCookTime(recipe, guiGraphics, 34);
    }

    protected void drawCookTime(RecipeHolder<CalcinationRecipe> recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = ((CalcinationRecipe)recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            guiGraphics.drawString(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CalcinationRecipe> recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.stream(((Ingredient)((CalcinationRecipe)recipe.value()).getIngredients().getFirst()).getItems()).map(i -> i.copyWithCount(((CalcinationRecipe)recipe.value()).getIngredientCount())).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 9).setBackground(JeiDrawables.OUTPUT_SLOT, -5, -5).addItemStack(((CalcinationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    @NotNull
    public RecipeType<RecipeHolder<CalcinationRecipe>> getRecipeType() {
        return JeiRecipeTypes.CALCINATION;
    }
}

