/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.integration.emi.EmiPlugin;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class IncubationEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<IncubationRecipe> recipe;

    public IncubationEmiRecipe(RecipeHolder<IncubationRecipe> recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.INCUBATION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return Arrays.asList(EmiIngredient.of((Ingredient)((IncubationRecipe)this.recipe.value()).getMercury()), EmiIngredient.of(Arrays.stream(((IncubationRecipe)this.recipe.value()).getSulfur().getItems()).map(EmiStack::of).toList()), EmiIngredient.of((Ingredient)((IncubationRecipe)this.recipe.value()).getSalt()));
    }

    public List<EmiStack> getOutputs() {
        return Arrays.stream(((IncubationRecipe)this.recipe.value()).getResult().getStacks()).map(EmiStack::of).toList();
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiStack.of(ItemRegistry.INCUBATOR_MERCURY_VESSEL), EmiStack.of(ItemRegistry.INCUBATOR_SULFUR_VESSEL), EmiStack.of(ItemRegistry.INCUBATOR_SALT_VESSEL));
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 24, 22);
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 28, 44);
        widgets.addSlot(EmiIngredient.of((Ingredient)((IncubationRecipe)this.recipe.value()).getMercury()), 1, 1);
        widgets.addSlot(EmiIngredient.of(Arrays.stream(((IncubationRecipe)this.recipe.value()).getSulfur().getItems()).map(EmiStack::of).toList()), 1, 21);
        widgets.addSlot(EmiIngredient.of((Ingredient)((IncubationRecipe)this.recipe.value()).getSalt()), 1, 42);
        widgets.addSlot(EmiIngredient.of(Arrays.stream(((IncubationRecipe)this.recipe.value()).getResult().getStacks()).map(i -> EmiStack.of((ItemLike)i.getItem(), (long)i.getCount())).toList()), 61, 22).recipeContext((EmiRecipe)this);
        int cookTime = ((IncubationRecipe)this.recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            widgets.addText((Component)timeString, this.getDisplayWidth() - stringWidth, 47, -8355712, false);
        }
    }
}

