/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class SmeltingRecipeProvider
extends JsonRecipeProvider {
    public SmeltingRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "smelting");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
    }

    protected void makeRecipe(SmeltingRecipeBuilder recipe) {
        this.makeRecipe(this.name((ItemLike)recipe.result.getItem()), recipe);
    }

    protected void makeRecipe(ItemLike result, SmeltingRecipeBuilder recipe) {
        this.makeRecipe(this.name((ItemLike)result.asItem()), recipe);
    }

    protected void makeRecipe(String name, SmeltingRecipeBuilder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String getName() {
        return "Smelting Recipes";
    }

    protected class SmeltingRecipeBuilder {
        private final JsonObject recipe;
        private final ItemStack result;

        public SmeltingRecipeBuilder(SmeltingRecipeProvider this$0, ItemLike result) {
            this(this$0, result, 1);
        }

        public SmeltingRecipeBuilder(SmeltingRecipeProvider this$0, ItemLike result, int count) {
            this(this$0, result, count, null);
        }

        public SmeltingRecipeBuilder(SmeltingRecipeProvider this$0, ItemLike result, int count, DataComponentPatch patch) {
            this(this$0, new ItemStack((Holder)result.asItem().builtInRegistryHolder(), count, patch));
        }

        public SmeltingRecipeBuilder(SmeltingRecipeProvider this$0, ItemStack result) {
            this.result = result;
            this.recipe = new JsonObject();
            this.recipe.addProperty("type", BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)RecipeSerializer.SMELTING_RECIPE).toString());
            this.recipe.add("result", (JsonElement)ItemStack.STRICT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow());
            this.recipe.addProperty("cookingtime", (Number)200);
            this.recipe.addProperty("experience", (Number)Float.valueOf(0.7f));
        }

        public SmeltingRecipeBuilder time(int time) {
            this.recipe.addProperty("cookingtime", (Number)time);
            return this;
        }

        public SmeltingRecipeBuilder experience(float exp) {
            this.recipe.addProperty("experience", (Number)Float.valueOf(exp));
            return this;
        }

        private JsonObject ingredient(TagKey<Item> tag) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", tag.location().toString());
            return jsonobject;
        }

        public SmeltingRecipeBuilder requires(TagKey<Item> tag) {
            return this.requires(this.ingredient(tag));
        }

        private JsonObject ingredient(ItemLike item) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ((ResourceKey)item.asItem().builtInRegistryHolder().unwrapKey().get()).location().toString());
            return jsonobject;
        }

        public SmeltingRecipeBuilder requires(ItemLike item) {
            return this.requires(this.ingredient(item));
        }

        public SmeltingRecipeBuilder requires(JsonObject ingredient) {
            this.recipe.add("ingredient", (JsonElement)ingredient);
            return this;
        }

        public JsonObject build() {
            if (!this.recipe.has("category")) {
                this.recipe.addProperty("category", CraftingBookCategory.MISC.getSerializedName());
            }
            return this.recipe;
        }

        public ItemStack result() {
            return this.result;
        }
    }
}

