/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeItem;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.niter.AlchemicalNiterItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.datagen.SulfurMappings;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.NiterRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class ReformationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;
    private static final Map<AlchemicalDerivativeTier, Integer> fluxPerTier = Map.of(AlchemicalDerivativeTier.ABUNDANT, 50, AlchemicalDerivativeTier.COMMON, 100, AlchemicalDerivativeTier.RARE, 150, AlchemicalDerivativeTier.PRECIOUS, 200);
    private final Map<ResourceLocation, JsonObject> recipeCache = new HashMap<ResourceLocation, JsonObject>();
    private Set<AlchemicalDerivativeItem> noAutomaticRecipesFor = Set.of();

    public ReformationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "reformation");
    }

    private static int getFlux(AlchemicalDerivativeItem item) {
        return fluxPerTier.get((Object)item.tier());
    }

    private void makeXtoXRecipes(List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> sulfurToTag) {
        sulfurToTag.forEach(entry -> ((List)entry.getFirst()).stream().filter(s -> !this.noAutomaticRecipesFor.contains(s)).forEach(sulfur -> this.makeTagRecipe((Item)sulfur, (TagKey<Item>)((TagKey)entry.getSecond()), ReformationRecipeProvider.getFlux(sulfur))));
    }

    private void makeNiterToSulfurRecipe(AlchemicalNiterItem source, AlchemicalSulfurItem target) {
        this.makeNiterToSulfurRecipe(source, 1, List.of(target), 1);
    }

    private void makeNiterToSulfurRecipe(AlchemicalNiterItem source, int sourceCount, AlchemicalSulfurItem target, int targetCount, boolean respectNoAutomaticRecipes) {
        this.makeNiterToSulfurRecipe(source, sourceCount, List.of(target), targetCount, respectNoAutomaticRecipes);
    }

    private void makeNiterToSulfurRecipe(AlchemicalNiterItem source, List<AlchemicalSulfurItem> targets) {
        this.makeNiterToSulfurRecipe(source, 1, targets, 1);
    }

    private void makeNiterToSulfurRecipe(AlchemicalNiterItem source, int sourceCount, List<AlchemicalSulfurItem> targets, int targetCount) {
        this.makeNiterToSulfurRecipe(source, sourceCount, targets, targetCount, true);
    }

    private void makeNiterToSulfurRecipe(AlchemicalNiterItem source, int sourceCount, List<AlchemicalSulfurItem> targets, int targetCount, boolean respectNoAutomaticRecipes) {
        targets.stream().filter(t -> !respectNoAutomaticRecipes || !this.noAutomaticRecipesFor.contains(t)).forEach(target -> this.makeRecipe((Item)target, targetCount, source, sourceCount, ReformationRecipeProvider.getFlux(target)));
    }

    private void makeNiterToNiterRecipe(AlchemicalNiterItem source, int sourceCount, AlchemicalNiterItem target, int targetCount) {
        this.makeRecipe(target, targetCount, source, sourceCount, ReformationRecipeProvider.getFlux(target));
    }

    private void earthenMatters() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), SulfurMappings.earthenMattersAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), SulfurMappings.earthenMattersCommon());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> earthenMattersFromEarthenMatters = List.of(Pair.of(SulfurMappings.earthenMattersAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_ABUNDANT), Pair.of(SulfurMappings.earthenMattersCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_COMMON));
        this.makeXtoXRecipes(earthenMattersFromEarthenMatters);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 8);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 8);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 16);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 16);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 8);
    }

    private void metals() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), SulfurMappings.metalsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), SulfurMappings.metalsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), SulfurMappings.metalsRare());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_PRECIOUS.get()), SulfurMappings.metalsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> metalsFromMetals = List.of(Pair.of(SulfurMappings.metalsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT), Pair.of(SulfurMappings.metalsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON), Pair.of(SulfurMappings.metalsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE), Pair.of(SulfurMappings.metalsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS));
        this.makeXtoXRecipes(metalsFromMetals);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_PRECIOUS.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_PRECIOUS.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_PRECIOUS.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_PRECIOUS.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 8, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 8, (AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 1);
    }

    private void gems() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), SulfurMappings.gemsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), SulfurMappings.gemsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), SulfurMappings.gemsRare());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_PRECIOUS.get()), SulfurMappings.gemsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> gemsFromGems = List.of(Pair.of(SulfurMappings.gemsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT), Pair.of(SulfurMappings.gemsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON), Pair.of(SulfurMappings.gemsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE), Pair.of(SulfurMappings.gemsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS));
        this.makeXtoXRecipes(gemsFromGems);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_PRECIOUS.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_PRECIOUS.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_PRECIOUS.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_PRECIOUS.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_COMMON.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), 8, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1);
        this.makeRecipe("", ((Builder)new Builder(new ItemStack((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 1)).time(100)).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4).sources((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 4));
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 16, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 16, (AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1);
    }

    private void otherMinerals() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), SulfurMappings.otherMineralsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), SulfurMappings.otherMineralsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), SulfurMappings.otherMineralsRare());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_PRECIOUS.get()), SulfurMappings.otherMineralsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> otherMineralsFromOtherMinerals = List.of(Pair.of(SulfurMappings.otherMineralsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT), Pair.of(SulfurMappings.otherMineralsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON), Pair.of(SulfurMappings.otherMineralsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE), Pair.of(SulfurMappings.otherMineralsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS));
        this.makeXtoXRecipes(otherMineralsFromOtherMinerals);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_PRECIOUS.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_PRECIOUS.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_PRECIOUS.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_PRECIOUS.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_COMMON.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 1);
    }

    private void logs() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), SulfurMappings.logsAbundant());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> logsFromLogs = List.of(Pair.of(SulfurMappings.logsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_ABUNDANT));
        this.makeXtoXRecipes(logsFromLogs);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 1);
    }

    private void crops() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), SulfurMappings.cropsAbundant());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> cropsFromCrops = List.of(Pair.of(SulfurMappings.cropsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_ABUNDANT));
        this.makeXtoXRecipes(cropsFromCrops);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 8);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 2);
    }

    private void animals() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), SulfurMappings.animalsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_COMMON.get()), SulfurMappings.animalsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_RARE.get()), SulfurMappings.animalsRare());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> animalsFromAnimal = List.of(Pair.of(SulfurMappings.animalsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_ABUNDANT), Pair.of(SulfurMappings.animalsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_COMMON), Pair.of(SulfurMappings.animalsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_RARE));
        this.makeXtoXRecipes(animalsFromAnimal);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.CROPS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.LOGS_ABUNDANT.get()), 2, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.EARTHEN_MATTERS_ABUNDANT.get()), 8, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.OTHER_MINERALS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_COMMON.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.METALS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_RARE.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_COMMON.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_RARE.get()), 1, (AlchemicalNiterItem)((Object)NiterRegistry.ANIMALS_RARE.get()), 4);
    }

    private void mobs() {
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_ABUNDANT.get()), SulfurMappings.mobsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_COMMON.get()), SulfurMappings.mobsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), SulfurMappings.mobsRare());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_PRECIOUS.get()), SulfurMappings.mobsPrecious());
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_COMMON.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.SKELETON_SKULL.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.WITHER_SKELETON_SKULL.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.GHAST_TEAR.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.SHULKER_SHELL.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.ELYTRA.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_PRECIOUS.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.NETHER_STAR.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_PRECIOUS.get()), 4, (AlchemicalSulfurItem)((Object)SulfurRegistry.DRAGON_EGG.get()), 1, false);
        this.makeNiterToSulfurRecipe((AlchemicalNiterItem)((Object)NiterRegistry.MOBS_PRECIOUS.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.HEART_OF_THE_SEA.get()), 1, false);
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> mobsFromMob = List.of(Pair.of(SulfurMappings.mobsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_ABUNDANT), Pair.of(SulfurMappings.mobsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_COMMON), Pair.of(SulfurMappings.mobsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_RARE), Pair.of(SulfurMappings.mobsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_PRECIOUS));
        this.makeXtoXRecipes(mobsFromMob);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_ABUNDANT.get()), 4, (AlchemicalNiterItem)((Object)NiterRegistry.MOBS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalNiterItem)((Object)NiterRegistry.GEMS_COMMON.get()), 8, (AlchemicalNiterItem)((Object)NiterRegistry.MOBS_COMMON.get()), 1);
        this.makeRecipe("", ((Builder)new Builder(new ItemStack((ItemLike)NiterRegistry.MOBS_RARE.get(), 1)).time(100)).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2).sources((ItemLike)NiterRegistry.GEMS_RARE.get(), 2));
        this.makeRecipe("", ((Builder)new Builder(new ItemStack((ItemLike)NiterRegistry.MOBS_PRECIOUS.get(), 1)).time(100)).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8).sources((ItemLike)NiterRegistry.GEMS_PRECIOUS.get(), 8));
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.noAutomaticRecipesFor = SulfurMappings.noAutomaticRecipesFor();
        this.earthenMatters();
        this.metals();
        this.gems();
        this.otherMinerals();
        this.logs();
        this.crops();
        this.animals();
        this.mobs();
        this.recipeCache.forEach(recipeConsumer);
    }

    public void makeTagRecipe(Item result, TagKey<Item> source, int mercuryFlux) {
        this.makeTagRecipe(result, 1, source, mercuryFlux);
    }

    public void makeTagRecipe(Item result, int resultCount, TagKey<Item> source, int mercuryFlux) {
        this.makeTagRecipe(this.name((ItemLike)result) + "_from_" + this.name(source), result, resultCount, List.of(source), mercuryFlux, 100);
    }

    public void makeTagRecipe(Item result, List<TagKey<Item>> sources, int mercuryFlux) {
        this.makeTagRecipe(result, 1, sources, mercuryFlux);
    }

    public void makeTagRecipe(Item result, int resultCount, List<TagKey<Item>> sources, int mercuryFlux) {
        this.makeTagRecipe(this.name((ItemLike)result) + "_from_" + this.name(sources), result, resultCount, sources, mercuryFlux, 100);
    }

    public void makeTagRecipe(String recipeName, Item result, int resultCount, List<TagKey<Item>> sources, int mercuryFlux, int reformationTime) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).target(result).mercuryFlux(mercuryFlux).time(reformationTime);
        sources.forEach(s -> recipe.sources((TagKey<Item>)s, 1));
        this.recipeCache.put(this.modLoc(recipeName), recipe.build());
    }

    public void makeRecipe(Item result, Item source, int mercuryFlux) {
        this.makeRecipe(result, 1, source, 1, mercuryFlux);
    }

    public void makeRecipe(Item result, int resultCount, Item source, int sourceCount, int mercuryFlux) {
        this.makeRecipe(this.name((ItemLike)result) + "_from_" + this.name((ItemLike)source), result, resultCount, Collections.nCopies(sourceCount, source).stream().toList(), mercuryFlux, 100);
    }

    public void makeRecipe(String recipeName, Item result, int resultCount, List<Item> sources, int mercuryFlux, int reformationTime) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).target(result).mercuryFlux(mercuryFlux).time(reformationTime);
        sources.forEach(recipe::sources);
        this.recipeCache.put(this.modLoc(recipeName), recipe.build());
    }

    protected void makeRecipe(String suffix, Builder recipe) {
        this.recipeConsumer.accept(this.modLoc(this.name(recipe.result()) + suffix), recipe.build());
    }

    @NotNull
    public String getName() {
        return "Reformation Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        private final ItemStack result;

        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.REFORMATION);
            this.result(result);
            this.result = result;
            this.target(result.getItem());
            Item item = result.getItem();
            if (item instanceof AlchemicalDerivativeItem) {
                AlchemicalDerivativeItem derivativeItem = (AlchemicalDerivativeItem)item;
                this.mercuryFlux(ReformationRecipeProvider.getFlux(derivativeItem));
            }
            this.time(100);
        }

        public ItemStack result() {
            return this.result;
        }

        @Override
        public Builder result(ItemStack result) {
            Item item = result.getItem();
            if (item instanceof AlchemicalSulfurItem) {
                AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
                if (result.has(DataComponentRegistry.SOURCE_TAG)) {
                    TagKey sourceTag = (TagKey)result.get(DataComponentRegistry.SOURCE_TAG);
                    this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(sourceTag)));
                }
            }
            return (Builder)super.result(result);
        }

        public Builder target(Item item) {
            AlchemicalSulfurItem sulfur;
            ItemStack stack;
            if (item instanceof AlchemicalSulfurItem && (stack = new ItemStack((ItemLike)(sulfur = (AlchemicalSulfurItem)item))).has(DataComponentRegistry.SOURCE_TAG)) {
                TagKey sourceTag = (TagKey)stack.get(DataComponentRegistry.SOURCE_TAG);
                this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(sourceTag)));
            }
            return (Builder)this.ingredient("target", item);
        }

        public Builder mercuryFlux(int mercuryFlux) {
            this.recipe.addProperty("mercuryFlux", (Number)mercuryFlux);
            return (Builder)this.getThis();
        }

        public Builder sources(ItemLike item) {
            return this.sources(item, 1);
        }

        public Builder sources(ItemLike item, int count) {
            AlchemicalSulfurItem sulfur;
            ItemStack stack;
            if (!this.recipe.has("sources")) {
                this.recipe.add("sources", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("sources").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of((ItemLike)item, (int)count)).getOrThrow());
            if (item instanceof AlchemicalSulfurItem && (stack = new ItemStack((ItemLike)(sulfur = (AlchemicalSulfurItem)item))).has(DataComponentRegistry.SOURCE_TAG)) {
                TagKey sourceTag = (TagKey)stack.get(DataComponentRegistry.SOURCE_TAG);
                this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(sourceTag)));
            }
            return (Builder)this.getThis();
        }

        public Builder sources(TagKey<Item> tag, int count) {
            if (!this.recipe.has("sources")) {
                this.recipe.add("sources", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("sources").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of(tag, (int)count)).getOrThrow());
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return (Builder)this.getThis();
        }
    }
}

