/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class FermentationRecipe
implements Recipe<ItemHandlerWithFluidRecipeInput> {
    public static final int DEFAULT_TIME = 200;
    public static final MapCodec<FermentationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedFluidIngredient.NESTED_CODEC.fieldOf("fluid").forGetter(r -> r.fluid), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.ingredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(r -> r.time)).apply((Applicative)instance, FermentationRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FermentationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, r -> r.fluid, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.ingredients, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.time, FermentationRecipe::new);
    protected final SizedFluidIngredient fluid;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int time;
    private final boolean hasOnlySimpleIngredients;

    public FermentationRecipe(SizedFluidIngredient fluid, List<Ingredient> ingredients, ItemStack result, int time) {
        this.fluid = fluid;
        this.ingredients = ingredients.stream().collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        this.hasOnlySimpleIngredients = ingredients.stream().allMatch(Ingredient::isSimple);
        this.result = result;
        this.time = time;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.FERMENTATION.get();
    }

    public boolean matches(ItemHandlerWithFluidRecipeInput pContainer, @NotNull Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean fluidMatches = this.fluid.test(fluid);
        if (!fluidMatches) {
            return false;
        }
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int containerItemsCount = 0;
        for (int j = 0; j < pContainer.size(); ++j) {
            ItemStack itemstack = pContainer.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++containerItemsCount;
            if (this.hasOnlySimpleIngredients) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        if (containerItemsCount != this.ingredients.size()) {
            return false;
        }
        return this.hasOnlySimpleIngredients ? stackedcontents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemHandlerWithFluidRecipeInput pInv, @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ItemRegistry.FERMENTATION_VAT.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.FERMENTATION.get();
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.amount();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationRecipe> {
        @NotNull
        public MapCodec<FermentationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FermentationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

