/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mercurialwand;

import com.klikli_dev.theurgy.content.item.HandlesOnLeftClick;
import com.klikli_dev.theurgy.content.item.mercurialwand.mode.MercurialWandItemMode;
import com.klikli_dev.theurgy.content.item.mode.ModeItem;
import com.klikli_dev.theurgy.content.render.itemhud.ItemHUDProvider;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class MercurialWandItem
extends Item
implements ItemHUDProvider,
ModeItem,
HandlesOnLeftClick {
    public MercurialWandItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void changeMode(Player player, ItemStack stack, int shift) {
        MercurialWandItemMode nextMode = ((MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get())).type().shift(shift).mode();
        stack.set((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get(), (Object)nextMode);
        player.displayClientMessage((Component)nextMode.description(stack, player.level()), true);
    }

    @Override
    public void onScroll(Player player, ItemStack stack, int shift) {
        MercurialWandItemMode mode = (MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get());
        if (mode.supportsScrollWithRightDown() && DistHelper.isRightPressed()) {
            mode.onScrollWithRightDown(player, stack, shift);
        } else {
            ModeItem.super.onScroll(player, stack, shift);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        MercurialWandItemMode mode = (MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get());
        InteractionResultHolder<ItemStack> result = mode.use(pLevel, pPlayer, pUsedHand);
        if (result.getResult() != InteractionResult.PASS) {
            return result;
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        MercurialWandItemMode mode = (MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get());
        InteractionResult result = mode.onItemUseFirst(stack, context);
        if (result != InteractionResult.PASS) {
            return result;
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public void appendHUDText(Player pPlayer, HitResult pHitResult, ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents) {
        ((MercurialWandItemMode)pStack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get())).appendHUDText(pPlayer, pHitResult, pStack, pLevel, pTooltipComponents);
    }

    @Override
    public boolean onLeftClickBlock(Level level, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        ItemStack stack = player.getItemInHand(hand);
        MercurialWandItemMode mode = (MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get());
        return mode.onLeftClickBlock(level, player, hand, pos, direction);
    }

    @Override
    public void onLeftClickEmpty(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        MercurialWandItemMode mode = (MercurialWandItemMode)stack.get((DataComponentType)DataComponentRegistry.MERCURIAL_WAND_ITEM_MODE.get());
        mode.onLeftClickEmpty(level, player, hand);
    }

    public static class DistHelper {
        public static boolean isRightPressed() {
            return Minecraft.getInstance().mouseHandler.isRightPressed();
        }
    }
}

