/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.logistics.distribution;

import com.klikli_dev.theurgy.content.behaviour.logistics.InsertTarget;
import com.klikli_dev.theurgy.content.behaviour.logistics.distribution.DistributionMode;
import com.klikli_dev.theurgy.content.behaviour.logistics.distribution.Distributor;
import java.util.List;

public class RoundRobinDistributor<T, C>
extends Distributor<T, C> {
    protected int currentTargetIndex;
    protected InsertTarget<T, C> cachedTarget;

    public RoundRobinDistributor(List<InsertTarget<T, C>> targets) {
        super(targets);
    }

    @Override
    public DistributionMode mode() {
        return DistributionMode.ROUND_ROBIN;
    }

    @Override
    public InsertTarget<T, C> target() {
        return this.cachedTarget;
    }

    @Override
    public void tick() {
        int oldIndex = this.currentTargetIndex;
        this.currentTargetIndex = this.targets.isEmpty() ? -1 : (this.currentTargetIndex + 1) % this.targets.size();
        if (oldIndex != this.currentTargetIndex || this.cachedTarget == null) {
            this.cachedTarget = this.currentTargetIndex >= 0 && this.currentTargetIndex < this.targets.size() ? (InsertTarget)this.targets.get(this.currentTargetIndex) : null;
        }
    }

    @Override
    public void onTargetsChanged() {
        this.cachedTarget = null;
        if (this.targets.isEmpty()) {
            this.currentTargetIndex = -1;
        } else if (this.currentTargetIndex >= this.targets.size()) {
            this.currentTargetIndex = 0;
        }
    }
}

