/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.render;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlockEntity;
import com.klikli_dev.theurgy.content.render.RenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class LiquefactionCauldronRenderer
implements BlockEntityRenderer<LiquefactionCauldronBlockEntity> {
    public LiquefactionCauldronRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(peek, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    public void render(LiquefactionCauldronBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.storageBehaviour.solventTank.isEmpty()) {
            return;
        }
        FluidStack fluidStack = pBlockEntity.storageBehaviour.solventTank.getFluid();
        Fluid fluid = fluidStack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        IClientFluidTypeExtensions fluidClientExtension = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidClientExtension.getStillTexture(fluidStack));
        int color = fluidClientExtension.getTintColor(fluidStack);
        int blockLightIn = pPackedLight >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidType.getLightLevel(fluidStack));
        int fluidLight = pPackedLight & 0xF00000 | luminosity << 4;
        float fluidHeight = (float)fluidStack.getAmount() / (float)pBlockEntity.storageBehaviour.solventTank.getCapacity();
        fluidHeight *= 0.875f;
        fluidHeight += 0.25f;
        pPoseStack.pushPose();
        float min = 0.25f;
        float max = 1.0f - min;
        VertexConsumer builder = pBufferSource.getBuffer(RenderTypes.fluid());
        float u1 = fluidTexture.getU0();
        float u2 = fluidTexture.getU1();
        float v1 = fluidTexture.getV0();
        float v2 = fluidTexture.getV1();
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, min, fluidHeight, min, color, u1, v1, Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, min, fluidHeight, max, color, u1, v2, Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, max, fluidHeight, max, color, u2, v2, Direction.UP, fluidLight);
        LiquefactionCauldronRenderer.putVertex(builder, pPoseStack, max, fluidHeight, min, color, u2, v1, Direction.UP, fluidLight);
        pPoseStack.popPose();
    }
}

