/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.incubator;

import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.IncubatorRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class IncubatorCraftingBehaviour
extends CraftingBehaviour<IncubatorRecipeInput, IncubationRecipe, RecipeManager.CachedCheck<IncubatorRecipeInput, IncubationRecipe>> {
    public IncubatorCraftingBehaviour(BlockEntity blockEntity, Supplier<IncubatorRecipeInput> recipeWrapperSupplier, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier) {
        super(blockEntity, recipeWrapperSupplier, inputInventorySupplier, outputInventorySupplier, RecipeManager.createCheck((RecipeType)((RecipeType)RecipeTypeRegistry.INCUBATION.get())));
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean craft(RecipeHolder<IncubationRecipe> pRecipe) {
        IncubatorRecipeInput ItemHandlerRecipeInput2 = (IncubatorRecipeInput)this.recipeInputSupplier.get();
        ItemStack assembledStack = ((IncubationRecipe)pRecipe.value()).assemble(ItemHandlerRecipeInput2, (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        ItemHandlerRecipeInput2.getMercuryVesselInv().extractItem(0, 1, false);
        ItemHandlerRecipeInput2.getSaltVesselInv().extractItem(0, 1, false);
        ItemHandlerRecipeInput2.getSulfurVesselInv().extractItem(0, 1, false);
        return true;
    }

    @Override
    protected int getIngredientCount(RecipeHolder<IncubationRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<IncubationRecipe> recipe) {
        return ((IncubationRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected int getTotalTime() {
        return this.recipeInputSupplier.get() != null ? super.getTotalTime() : this.getDefaultCraftingTime();
    }
}

